package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaModel;
import cn.ibizlab.core.lite.filter.MetaModelSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MetaModel] 服务对象接口
 */
public interface IMetaModelService extends IService<MetaModel> {

    boolean create(MetaModel et);
    @CacheEvict(value = "metamodel", allEntries = true)
    void createBatch(List<MetaModel> list);
    boolean update(MetaModel et);
    @CacheEvict(value = "metamodel", allEntries = true)
    void updateBatch(List<MetaModel> list);
    boolean remove(String key);
    @CacheEvict(value = "metamodel", allEntries = true)
    void removeBatch(Collection<String> idList);
    MetaModel get(String key);
    MetaModel getDraft(MetaModel et);
    MetaModel change(MetaModel et);
    boolean checkKey(MetaModel et);
    boolean save(MetaModel et);
    @CacheEvict(value = "metamodel",allEntries = true)
    void saveBatch(List<MetaModel> list);
    Page<MetaModel> searchDefault(MetaModelSearchContext context);
    List<MetaModel> selectBySystemId(String pssystemid);
    @CacheEvict(value = "metamodel", allEntries = true)
    void removeBySystemId(String pssystemid);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


