package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.MetaEntity;
import cn.ibizlab.core.lite.filter.MetaEntitySearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MetaEntity] 服务对象接口
 */
public interface IMetaEntityService extends IService<MetaEntity> {

    boolean create(MetaEntity et);
    void createBatch(List<MetaEntity> list);
    boolean update(MetaEntity et);
    void updateBatch(List<MetaEntity> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MetaEntity get(String key);
    MetaEntity getDraft(MetaEntity et);
    boolean checkKey(MetaEntity et);
    MetaEntity getDefaultModel(MetaEntity et);
    boolean save(MetaEntity et);
    void saveBatch(List<MetaEntity> list);
    Page<MetaEntity> searchDefault(MetaEntitySearchContext context);
    List<MetaEntity> selectByDsId(String ds_id);
    void removeByDsId(String ds_id);
    List<MetaEntity> selectBySystemId(String pssystemid);
    void removeBySystemId(String pssystemid);
    List<MetaEntity> selectByModuleId(String id);
    void removeByModuleId(String id);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


