package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DstSystem;
import cn.ibizlab.core.lite.filter.DstSystemSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[DstSystem] 服务对象接口
 */
public interface IDstSystemService extends IService<DstSystem> {

    boolean create(DstSystem et);
    void createBatch(List<DstSystem> list);
    boolean update(DstSystem et);
    void updateBatch(List<DstSystem> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DstSystem get(String key);
    DstSystem getDraft(DstSystem et);
    boolean checkKey(DstSystem et);
    DstSystem initDefaultDataSource(DstSystem et);
    boolean save(DstSystem et);
    void saveBatch(List<DstSystem> list);
    DstSystem syncSysModel(DstSystem et);
    Page<DstSystem> searchDefault(DstSystemSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


