package cn.ibizlab.core.lite.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.lite.domain.DstAPI;
import cn.ibizlab.core.lite.filter.DstAPISearchContext;


/**
 * 实体[DstAPI] 服务对象接口
 */
public interface IDstAPIService {

    boolean create(DstAPI et);
    void createBatch(List<DstAPI> list);
    boolean update(DstAPI et);
    void updateBatch(List<DstAPI> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DstAPI get(String key);
    DstAPI getDraft(DstAPI et);
    boolean checkKey(DstAPI et);
    boolean save(DstAPI et);
    void saveBatch(List<DstAPI> list);
    Page<DstAPI> searchDefault(DstAPISearchContext context);
    List<DstAPI> selectByMsId(String id);
    void removeByMsId(String id);
    List<DstAPI> selectBySystemId(String pssystemid);
    void removeBySystemId(String pssystemid);

}



