package cn.ibizlab.core.lite.mapper;

import java.util.List;
import org.apache.ibatis.annotations.*;
import java.util.Map;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.HashMap;
import org.apache.ibatis.annotations.Select;
import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.filter.MetaFieldSearchContext;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import java.io.Serializable;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.alibaba.fastjson.JSONObject;

public interface MetaFieldMapper extends BaseMapper<MetaField> {

    Page<MetaField> searchDefault(IPage page, @Param("srf") MetaFieldSearchContext context, @Param("ew") Wrapper<MetaField> wrapper);
    @Override
    MetaField selectById(Serializable id);
    @Override
    int insert(MetaField entity);
    @Override
    int updateById(@Param(Constants.ENTITY) MetaField entity);
    @Override
    int update(@Param(Constants.ENTITY) MetaField entity, @Param("ew") Wrapper<MetaField> updateWrapper);
    @Override
    int deleteById(Serializable id);
    /**
    * 自定义查询SQL
    * @param sql
    * @return
    */
    @Select("${sql}")
    List<JSONObject> selectBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义更新SQL
    * @param sql
    * @return
    */
    @Update("${sql}")
    boolean updateBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义插入SQL
    * @param sql
    * @return
    */
    @Insert("${sql}")
    boolean insertBySQL(@Param("sql") String sql, @Param("et")Map param);

    /**
    * 自定义删除SQL
    * @param sql
    * @return
    */
    @Delete("${sql}")
    boolean deleteBySQL(@Param("sql") String sql, @Param("et")Map param);

    List<MetaField> selectByEntityId(@Param("entity_id") Serializable entity_id);

    List<MetaField> selectByRefFieldId(@Param("field_id") Serializable field_id);

    List<MetaField> selectByRelationId(@Param("id") Serializable id);

}
