package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.MetaDataSet;
/**
 * 关系型数据实体[MetaDataSet] 查询条件对象
 */
@Slf4j
@Data
public class MetaDataSetSearchContext extends QueryWrapperContext<MetaDataSet> {

	private String n_datasetname_like;//[名称]
	public void setN_datasetname_like(String n_datasetname_like) {
        this.n_datasetname_like = n_datasetname_like;
        if(!ObjectUtils.isEmpty(this.n_datasetname_like)){
            this.getSearchCond().like("datasetname", n_datasetname_like);
        }
    }
	private String n_entityid_eq;//[实体标识]
	public void setN_entityid_eq(String n_entityid_eq) {
        this.n_entityid_eq = n_entityid_eq;
        if(!ObjectUtils.isEmpty(this.n_entityid_eq)){
            this.getSearchCond().eq("entityid", n_entityid_eq);
        }
    }
	private String n_entityname_eq;//[实体]
	public void setN_entityname_eq(String n_entityname_eq) {
        this.n_entityname_eq = n_entityname_eq;
        if(!ObjectUtils.isEmpty(this.n_entityname_eq)){
            this.getSearchCond().eq("entityname", n_entityname_eq);
        }
    }
	private String n_entityname_like;//[实体]
	public void setN_entityname_like(String n_entityname_like) {
        this.n_entityname_like = n_entityname_like;
        if(!ObjectUtils.isEmpty(this.n_entityname_like)){
            this.getSearchCond().like("entityname", n_entityname_like);
        }
    }
	private String n_codename_like;//[代码名称]
	public void setN_codename_like(String n_codename_like) {
        this.n_codename_like = n_codename_like;
        if(!ObjectUtils.isEmpty(this.n_codename_like)){
            this.getSearchCond().like("codename", n_codename_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("datasetname", query)
            );
		 }
	}
}



