package cn.ibizlab.core.lite.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.lite.domain.DstView;
/**
 * 关系型数据实体[DstView] 查询条件对象
 */
@Slf4j
@Data
public class DstViewSearchContext extends QueryWrapperContext<DstView> {

	private String n_viewname_like;//[名称]
	public void setN_viewname_like(String n_viewname_like) {
        this.n_viewname_like = n_viewname_like;
        if(!ObjectUtils.isEmpty(this.n_viewname_like)){
            this.getSearchCond().like("viewname", n_viewname_like);
        }
    }
	private String n_viewpath_like;//[视图路径]
	public void setN_viewpath_like(String n_viewpath_like) {
        this.n_viewpath_like = n_viewpath_like;
        if(!ObjectUtils.isEmpty(this.n_viewpath_like)){
            this.getSearchCond().like("viewpath", n_viewpath_like);
        }
    }
	private String n_systemid_eq;//[系统标识]
	public void setN_systemid_eq(String n_systemid_eq) {
        this.n_systemid_eq = n_systemid_eq;
        if(!ObjectUtils.isEmpty(this.n_systemid_eq)){
            this.getSearchCond().eq("systemid", n_systemid_eq);
        }
    }
	private String n_appid_eq;//[应用标识]
	public void setN_appid_eq(String n_appid_eq) {
        this.n_appid_eq = n_appid_eq;
        if(!ObjectUtils.isEmpty(this.n_appid_eq)){
            this.getSearchCond().eq("appid", n_appid_eq);
        }
    }
	private String n_entityid_eq;//[实体标识]
	public void setN_entityid_eq(String n_entityid_eq) {
        this.n_entityid_eq = n_entityid_eq;
        if(!ObjectUtils.isEmpty(this.n_entityid_eq)){
            this.getSearchCond().eq("entityid", n_entityid_eq);
        }
    }
	private String n_entityname_eq;//[主实体]
	public void setN_entityname_eq(String n_entityname_eq) {
        this.n_entityname_eq = n_entityname_eq;
        if(!ObjectUtils.isEmpty(this.n_entityname_eq)){
            this.getSearchCond().eq("entityname", n_entityname_eq);
        }
    }
	private String n_entityname_like;//[主实体]
	public void setN_entityname_like(String n_entityname_like) {
        this.n_entityname_like = n_entityname_like;
        if(!ObjectUtils.isEmpty(this.n_entityname_like)){
            this.getSearchCond().like("entityname", n_entityname_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("viewname", query)
            );
		 }
	}
}



