package cn.ibizlab.core.lite.extensions.service;

import cn.ibizlab.core.extensions.service.DstDataSourceExService;
import cn.ibizlab.core.lite.domain.DstDataSource;
import cn.ibizlab.core.lite.extensions.domain.*;
import cn.ibizlab.core.lite.extensions.filter.DbEntitySearchContext;
import cn.ibizlab.core.lite.extensions.model.DataModel;
import cn.ibizlab.core.lite.extensions.model.Property;
import cn.ibizlab.core.lite.extensions.util.LiteStorage;
import cn.ibizlab.core.extensions.mapper.DbEntityMapper;
import cn.ibizlab.core.lite.service.IDstDataSourceService;
import cn.ibizlab.core.lite.service.IMetaModelService;
import cn.ibizlab.util.filter.QueryFilter;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

@Service
@Primary
@Slf4j
public class DbEntityService extends ServiceImpl<DbEntityMapper, EntityObj> implements CommonEntityService{



    @Autowired
    private DstDataSourceExService dstDataSourceService;



    @Override
    public List<EntityObj> selectBase(EntityModel entityModel, QueryFilter filter) {
        return search("BASE",entityModel,filter);
    }

    @Override
    public List<EntityObj> selectCore(EntityModel entityModel, QueryFilter filter) {
        return search("CORE",entityModel,filter);
    }

    @Override
    public List<EntityObj> search(String dataSet, EntityModel entityModel, QueryFilter filter) {

        String sql=entityModel.getSqlSegment(dataSet);
        if(StringUtils.isEmpty(sql))
            return new ArrayList<>();
        else
            return search(entityModel.getDsName(),sql,filter);
    }

    @Override
    public List<EntityObj> search(String dsName, String sql, QueryFilter filter) {
        try
        {
            dstDataSourceService.initDataSource(dsName);
            DynamicDataSourceContextHolder.push(dsName);
            DbEntitySearchContext context=new DbEntitySearchContext();
            context.setFilter(filter);
            QueryWrapper qw=context.getSelectCond();
            if(!StringUtils.isEmpty(filter.getCustSqlSegment()))
                qw.apply(filter.getCustSqlSegment());

            return baseMapper.search(sql,qw);
        }
        catch(Exception ex)
        {
            log.error("详细错误信息：" + ex.getMessage() + ", 执行sql：" + sql);
            return null;
        }
        finally
        {
            DynamicDataSourceContextHolder.poll();
        }
    }

    @Autowired
    private IMetaModelService metaModelService;

    @Autowired
    private LiteModelService liteModelService;


    @Override
    public List<ModelObj> getModelObjs(String metaModelId,Timestamp lastModify)
    {
        DataModel dataModel= JSON.toJavaObject(JSON.parseObject(metaModelService.get(metaModelId).getConfig()),DataModel.class);
        EntityModel entityModel=dataModel.getFactEntityModel();
        FieldModel lastModifyField=entityModel.getLastModifyField();
        QueryFilter filter=new QueryFilter();
        
        if(lastModifyField!=null)
            filter.ge(lastModifyField.getColumnName(), lastModify);

        List<EntityObj> kEntityObjs=this.selectCore(entityModel, filter);
        
        return getModelObjs(dataModel,kEntityObjs);
    }

    @Override
    public ModelObj getModelObjs(String metaModelId, Object factKey)
    {
        DataModel dataModel= JSON.toJavaObject(JSON.parseObject(metaModelService.get(metaModelId).getConfig()),DataModel.class);
        List<EntityObj> kEntityObjs = new ArrayList<>();
        kEntityObjs.add(new EntityObj().set(dataModel.getFactEntityModel().getKeyField().getColumnName(),factKey));
        List<ModelObj> list = getModelObjs(dataModel,kEntityObjs);
        if(list.size()>0)
            return list.get(0);
        return null;
    }

    @Override
    public ModelObj getModelObjs(String metaModelId, Object... factUniKey)
    {
        DataModel dataModel= JSON.toJavaObject(JSON.parseObject(metaModelService.get(metaModelId).getConfig()),DataModel.class);
        List<EntityObj> kEntityObjs = new ArrayList<>();
        EntityObj entityObj = new EntityObj();
        List<FieldModel> uniKeys = dataModel.getFactEntityModel().getUnionKeyFields();
        for(int i=0;i<uniKeys.size();i++)
            entityObj.set(uniKeys.get(i).getColumnName(),factUniKey[i]);
        kEntityObjs.add(entityObj);
        List<ModelObj> list = getModelObjs(dataModel,kEntityObjs);
        if(list.size()>0)
            return list.get(0);
        return null;
    }

    @Override
    public List<ModelObj> getModelObjs(String metaModelId, List<EntityObj> kEntityObjs)
    {
        DataModel dataModel= JSON.toJavaObject(JSON.parseObject(metaModelService.get(metaModelId).getConfig()),DataModel.class);
        return getModelObjs(dataModel,kEntityObjs);
    }

    public List<ModelObj> getModelObjs(DataModel dataModel, List<EntityObj> kEntityObjs)
    {
        EntityModel entityModel=dataModel.getFactEntityModel();
        List<ModelObj> rt=new ArrayList<>();
        List<EntityObj> factEntityList = this.selectBase(entityModel,QueryFilter.createQuery().cust(dataModel.lookup(kEntityObjs)));
        factEntityList.forEach(entityObj->
                rt.add(new ModelObj().setDataModel(dataModel).setFactEntity(entityObj.setProperty(dataModel.getFactPorperty()))));
        fillEntityObj(dataModel,rt);
        dataModel.getNestedDataModels().forEach(subModel->
                this.getModelObjs(subModel, factEntityList).forEach(subObj->subObj.findParent(rt)));
        rt.forEach(modelObj -> modelObj.getTimestamp());
        return rt;
    }

    public void fillEntityObj(DataModel dataModel,List<ModelObj> modelObjs)
    {
        if(dataModel.getObjectProperties().size()>1)
        {
            for(Property property:dataModel.getObjectProperties())
            {
                if(property.getPropertyName().equals(dataModel.getFactPorperty().getPropertyName()))
                    continue;
                EntityModel entityModel=property.getEntityModel();
                List<EntityObj> entityObjs = this.selectBase(entityModel,QueryFilter.createQuery().cust(property.lookup(modelObjs)));
                entityObjs.forEach(entityObj -> {
                    entityObj.setProperty(property);
                    entityObj.findModel(modelObjs);
                });
            }
        }
    }


}
