package cn.ibizlab.core.lite.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[配置]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBZCFG", resultMap = "DstConfigResultMap")
public class DstConfig extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "cfgid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "cfg_id")
    @JsonProperty("cfg_id")
    private String cfgId;
    /**
     * 系统标识
     */
    @TableField(value = "systemid")
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 配置类型
     */
    @TableField(value = "cfgtype")
    @JSONField(name = "cfg_type")
    @JsonProperty("cfg_type")
    private String cfgType;
    /**
     * 引用类型
     */
    @TableField(value = "targettype")
    @JSONField(name = "target_type")
    @JsonProperty("target_type")
    private String targetType;
    /**
     * 用户标识
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "userid")
    @JSONField(name = "user_id")
    @JsonProperty("user_id")
    private String userId;
    /**
     * 配置内容
     */
    @TableField(value = "cfg")
    @JSONField(name = "cfg")
    @JsonProperty("cfg")
    private String cfg;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "update_date", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("update_date")
    private Timestamp updateDate;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.lite.domain.DstSystem system;



    /**
     * 设置 [系统标识]
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.modify("systemid", systemId);
    }

    /**
     * 设置 [配置类型]
     */
    public void setCfgType(String cfgType) {
        this.cfgType = cfgType;
        this.modify("cfgtype", cfgType);
    }

    /**
     * 设置 [引用类型]
     */
    public void setTargetType(String targetType) {
        this.targetType = targetType;
        this.modify("targettype", targetType);
    }

    /**
     * 设置 [配置内容]
     */
    public void setCfg(String cfg) {
        this.cfg = cfg;
        this.modify("cfg", cfg);
    }


    /**
     * 获取 [标识]
     */
    public String getCfgId() {
        if(ObjectUtils.isEmpty(cfgId)) {
            cfgId=(String)getDefaultKey(true);
        }
        return cfgId;
    }

    @Override
    public Serializable getDefaultKey(boolean gen) {
        if((!ObjectUtils.isEmpty(this.getSystemId()))&&(!ObjectUtils.isEmpty(this.getCfgType()))&&(!ObjectUtils.isEmpty(this.getTargetType()))&&(!ObjectUtils.isEmpty(this.getUserId())))
            return DigestUtils.md5DigestAsHex(String.format("%s||%s||%s||%s" ,this.getSystemId(),this.getCfgType(),this.getTargetType(),this.getUserId()).getBytes());
        return null;
    }
    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("cfgid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


