package cn.ibizlab.core.extensions.service;

import cn.ibizlab.core.lite.extensions.model.DataModel;
import cn.ibizlab.core.lite.extensions.model.TmpModel;
import cn.ibizlab.core.lite.service.impl.MetaModelServiceImpl;
import cn.ibizlab.util.errors.BadRequestAlertException;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.core.lite.domain.MetaModel;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * 实体[模型] 自定义服务对象
 */
@Slf4j
@Primary
@Service("MetaModelExService")
public class MetaModelExService extends MetaModelServiceImpl {

    @Override
    protected Class currentModelClass() {
        return com.baomidou.mybatisplus.core.toolkit.ReflectionKit.getSuperClassGenericType(this.getClass().getSuperclass(), 1);
    }

    /**
     * 自定义行为[Change]用户扩展
     * @param et
     * @return
     */
    @Override
    @Transactional
    public MetaModel change(MetaModel et) {
        if((!StringUtils.isEmpty(et.getConfig()))&&et.getConfig().indexOf("releations")>0)
        {
            TmpModel tmpModel= JSONObject.parseObject(et.getConfig(),TmpModel.class);
            DataModel root=tmpModel.getDataModels();
            if(tmpModel.getTables().size()>0) {
                System.out.println(tmpModel.getTables());
                //throw new BadRequestAlertException("结构分析失败","MetaModel",tmpModel.getFactEntity());
            }
            else
                et.setConfig(JSONObject.toJSONString(root));
        }
        return super.change(et);
    }


    @Override
    public boolean create(MetaModel et) {
        change(et);
        return super.create(et);
    }

    @Override
    public boolean update(MetaModel et) {
        change(et);
        return super.update(et);
    }
}

