package cn.ibizlab.core.extensions.service;

import cn.ibizlab.core.lite.service.impl.MetaEntityServiceImpl;
import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.core.lite.domain.MetaEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Primary;
import java.util.*;

/**
 * 实体[实体] 自定义服务对象
 */
@Slf4j
@Primary
@Service("MetaEntityExService")
public class MetaEntityExService extends MetaEntityServiceImpl {

    @Override
    protected Class currentModelClass() {
        return com.baomidou.mybatisplus.core.toolkit.ReflectionKit.getSuperClassGenericType(this.getClass().getSuperclass(), 1);
    }

    /**
     * [GetDefaultModel:GetDefaultModel] 行为扩展
     * @param et
     * @return
     */
    @Override
    @Transactional
    public MetaEntity getDefaultModel(MetaEntity et) {
        return super.getDefaultModel(et);
    }
}

