package cn.ibizlab.core.extensions.service;

import cn.ibizlab.core.lite.domain.DstDataSource;
import cn.ibizlab.core.lite.domain.DstSystem;
import cn.ibizlab.core.lite.service.IDstDataSourceService;
import cn.ibizlab.core.lite.service.impl.DstSystemServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.sql.Wrapper;

/**
 * 实体[系统] 自定义服务对象
 */
@Slf4j
@Primary
@Service("DstSystemExService")
public class DstSystemExService extends DstSystemServiceImpl {

    @Override
    protected Class currentModelClass() {
        return com.baomidou.mybatisplus.core.toolkit.ReflectionKit.getSuperClassGenericType(this.getClass().getSuperclass(), 1);
    }

    @Autowired
    private IDstDataSourceService dstDataSourceService;

    @Override
    public DstSystem initDefaultDataSource(DstSystem et) {
        String dsName=et.getPssystemid()+"-master";
        if(dstDataSourceService.count(Wrappers.<DstDataSource>lambdaQuery().eq(DstDataSource::getDsId,dsName).or().eq(DstDataSource::getDsName,dsName))>0)
            return et;
        DstDataSource dstDataSource=new DstDataSource();
        dstDataSource.setDsId(dsName);
        dstDataSource.setDsName(dsName);
        dstDataSourceService.create(dstDataSource);
        return super.initDefaultDataSource(et);
    }

    @Override
    public boolean create(DstSystem et) {
        if(!super.create(et))
            return false;
        initDefaultDataSource(et);
        return true;
    }

    @Override
    public boolean update(DstSystem et) {
        if(!super.create(et))
            return false;
        initDefaultDataSource(et);
        return true;
    }
}

