package cn.ibizlab.core.extensions.service;

import cn.ibizlab.core.lite.extensions.domain.Setting;
import cn.ibizlab.core.lite.extensions.domain.SysModel;
import cn.ibizlab.core.lite.extensions.service.LiteCoreService;
import cn.ibizlab.core.lite.service.IDstDataSourceService;
import cn.ibizlab.core.lite.service.impl.DstDataSourceServiceImpl;
import cn.ibizlab.util.domain.LiquibaseProp;
import cn.ibizlab.util.errors.BadRequestAlertException;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import liquibase.integration.spring.GenerateLiquibaseChangeLog;
import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.core.lite.domain.DstDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.util.*;

import static cn.ibizlab.core.lite.extensions.util.LiteStorage.parseDatasource;

/**
 * 实体[数据源] 自定义服务对象
 */
@Slf4j
@Primary
@Service("DstDataSourceExService")
public class DstDataSourceExService extends DstDataSourceServiceImpl {

    @Override
    protected Class currentModelClass() {
        return com.baomidou.mybatisplus.core.toolkit.ReflectionKit.getSuperClassGenericType(this.getClass().getSuperclass(), 1);
    }
    @Resource
    public LiteCoreService liteCoreService;

    @Resource
    public GenerateLiquibaseChangeLog generateLiquibaseChangeLog;

    /**
     * [BuildDS:buildDS] 行为扩展
     * @param dstDataSource
     * @return
     */
    @Override
    @Transactional
    public DstDataSource buildDS(DstDataSource dstDataSource) {

        if(!(StringUtils.isEmpty(dstDataSource.getDsCfg())))
        {
            synchronized (lock)
            {
                if (check.containsKey(dstDataSource.getDsName()))
                    return super.buildDS(dstDataSource);
                DataSourceProperty dataSourceProperty = new DataSourceProperty();
                DynamicRoutingDataSource ds = dataSource;
                List<Setting> settings = JSONArray.parseArray(dstDataSource.getDsCfg(), Setting.class);
                for (Setting setting : settings)
                {
                    if (setting.getProperty().equalsIgnoreCase("driver-class-name"))
                        dataSourceProperty.setDriverClassName(setting.getValue());
                    else if (setting.getProperty().equalsIgnoreCase("username"))
                        dataSourceProperty.setUsername(setting.getValue());
                    else if (setting.getProperty().equalsIgnoreCase("password"))
                        dataSourceProperty.setPassword(setting.getValue());
                    else if (setting.getProperty().equalsIgnoreCase("url"))
                        dataSourceProperty.setUrl(setting.getValue());
                    else if (setting.getProperty().equalsIgnoreCase("defaultSchema"))
                        dataSourceProperty.setSchema(setting.getValue());
                }

                dataSourceProperty.getDruid().setFilters("stat,log4j2");
                DataSource dataSource = druidDataSourceCreator.createDataSource(dataSourceProperty);

                ds.addDataSource(dstDataSource.getDsName(), dataSource);
                check.put(dstDataSource.getDsName(), 1);
            }
        }

        return super.buildDS(dstDataSource);
    }

    @Autowired
    @Lazy
    private DynamicRoutingDataSource dataSource;

    @Autowired
    @Lazy
    private DataSourceCreator druidDataSourceCreator;


    private HashMap<String,Integer> check=new HashMap<>();
    private Object lock=new Object();

    public void initDataSource(String dsName)
    {
        synchronized (lock)
        {
            if (check.containsKey(dsName))
                return;
        }

        DstDataSource dstDataSource=this.getOne(Wrappers.<DstDataSource>lambdaQuery().eq(DstDataSource::getDsId,dsName).or().eq(DstDataSource::getDsName,dsName),false);
        if(dstDataSource!=null)
        {
            dstDataSource.setDsName(dsName);
            buildDS(dstDataSource);

        }

    }

    @Override
    public boolean update(DstDataSource et) {
        if(!super.update(et))
            return false;
        synchronized (lock)
        {
            DynamicRoutingDataSource ds = (DynamicRoutingDataSource) dataSource;
            if (check.containsKey(et.getDsId()))
            {
                ds.removeDataSource(et.getDsId());
                check.remove(et.getDsId());
            }
            if (check.containsKey(et.getDsName()))
            {
                ds.removeDataSource(et.getDsName());
                check.remove(et.getDsName());
            }
        }
        buildDS(et);

        return true;
    }
    @Override
    @Transactional
    public DstDataSource initDS(DstDataSource et) {
        DstDataSource ds = get(et.getDsId());
        String datasourceMessage = ds.getDsCfg();

        Map datasourceMap = parseDatasource(datasourceMessage);

        if(ObjectUtils.isEmpty(datasourceMap.get("username"))){
            throw new BadRequestAlertException("数据源用户名不能为空！","","ibzInit");
        }
        if(ObjectUtils.isEmpty(datasourceMap.get("password"))){
            throw new BadRequestAlertException("数据源密码不能为空！","","ibzInit");
        }
        if(ObjectUtils.isEmpty(datasourceMap.get("url"))){
            throw new BadRequestAlertException("数据源地址不能为空！","","ibzInit");
        }
        if(ObjectUtils.isEmpty(datasourceMap.get("defaultSchema"))){
            throw new BadRequestAlertException("数据源默认数据库不能为空！","","ibzInit");
        }
        LiquibaseProp lp = new LiquibaseProp();
        lp.setUsername(datasourceMap.get("username") == null?"":datasourceMap.get("username").toString());
        lp.setPassword(datasourceMap.get("password") == null?"":datasourceMap.get("password").toString());
        lp.setUrl(datasourceMap.get("url") == null?"":datasourceMap.get("url").toString());
        lp.setDefaultSchema(datasourceMap.get("defaultSchema") == null?"":datasourceMap.get("defaultSchema").toString());
        // 调用liquibase逆向工程的逻辑，生成一个xml，并返回一个SysModel对象
        SysModel sysModel = generateLiquibaseChangeLog.liquibaseGenerateChangeLog(lp,ds.getDsId());

        liteCoreService.syncSysModel(sysModel);
        return et;
    }
}

