package cn.ibizlab.core.avuedata.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.avuedata.domain.BladeVisual;
import cn.ibizlab.core.avuedata.filter.BladeVisualSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[BladeVisual] 服务对象接口
 */
public interface IBladeVisualService extends IService<BladeVisual> {

    boolean create(BladeVisual et);
    void createBatch(List<BladeVisual> list);
    boolean update(BladeVisual et);
    void updateBatch(List<BladeVisual> list);
    boolean remove(Long key);
    void removeBatch(Collection<Long> idList);
    BladeVisual get(Long key);
    BladeVisual getDraft(BladeVisual et);
    boolean checkKey(BladeVisual et);
    boolean save(BladeVisual et);
    void saveBatch(List<BladeVisual> list);
    Page<BladeVisual> searchDefault(BladeVisualSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


