package cn.ibizlab.core.avuedata.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.avuedata.domain.BladeVisualConfig;
import cn.ibizlab.core.avuedata.filter.BladeVisualConfigSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[BladeVisualConfig] 服务对象接口
 */
public interface IBladeVisualConfigService extends IService<BladeVisualConfig> {

    boolean create(BladeVisualConfig et);
    void createBatch(List<BladeVisualConfig> list);
    boolean update(BladeVisualConfig et);
    void updateBatch(List<BladeVisualConfig> list);
    boolean remove(Long key);
    void removeBatch(Collection<Long> idList);
    BladeVisualConfig get(Long key);
    BladeVisualConfig getDraft(BladeVisualConfig et);
    boolean checkKey(BladeVisualConfig et);
    boolean save(BladeVisualConfig et);
    void saveBatch(List<BladeVisualConfig> list);
    Page<BladeVisualConfig> searchDefault(BladeVisualConfigSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

}


