import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 接口服务对象基类
 *
 * @export
 * @class DstAPIServiceBase
 * @extends {EntityServie}
 */
export default class DstAPIServiceBase extends EntityService {

    /**
     * Creates an instance of  DstAPIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DstAPIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof DstAPIServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='dstapi';
        this.APPDEKEY = 'id';
        this.APPDENAME = 'dstapis';
        this.APPDETEXT = 'name';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzlite';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && context.dstapi){
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}/select`,isloading);
            
            return res;
        }
        if(context.dstmicroservice && context.dstapi){
            let res:any = Http.getInstance().get(`/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}/select`,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/dstapis/${context.dstapi}/select`,isloading);
            
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis`,data,isloading);
            
            return res;
        }
        if(context.dstmicroservice && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/dstmicroservices/${context.dstmicroservice}/dstapis`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/dstapis`,data,isloading);
        
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && context.dstapi){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}`,data,isloading);
            
            return res;
        }
        if(context.dstmicroservice && context.dstapi){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/dstapis/${context.dstapi}`,data,isloading);
            
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && context.dstapi){
            let res:any = Http.getInstance().delete(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}`,isloading);
            return res;
        }
        if(context.dstmicroservice && context.dstapi){
            let res:any = Http.getInstance().delete(`/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}`,isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/dstapis/${context.dstapi}`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && context.dstapi){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}`,isloading);
            
            return res;
        }
        if(context.dstmicroservice && context.dstapi){
            let res:any = await Http.getInstance().get(`/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}`,isloading);
            
            return res;
        }
            let res:any = await Http.getInstance().get(`/dstapis/${context.dstapi}`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && true){
            let res:any = await Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/getdraft`,isloading);
            res.data.dstapi = data.dstapi;
            
            return res;
        }
        if(context.dstmicroservice && true){
            let res:any = await Http.getInstance().get(`/dstmicroservices/${context.dstmicroservice}/dstapis/getdraft`,isloading);
            res.data.dstapi = data.dstapi;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/dstapis/getdraft`,isloading);
        res.data.dstapi = data.dstapi;
        
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && context.dstapi){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}/checkkey`,data,isloading);
            
            return res;
        }
        if(context.dstmicroservice && context.dstapi){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/dstapis/${context.dstapi}/checkkey`,data,isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && context.dstapi){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}/save`,data,isloading);
            
            return res;
        }
        if(context.dstmicroservice && context.dstapi){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/dstmicroservices/${context.dstmicroservice}/dstapis/${context.dstapi}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/dstapis/${context.dstapi}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof DstAPIServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.dstsystem && context.dstmicroservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstsystems/${context.dstsystem}/dstmicroservices/${context.dstmicroservice}/dstapis/fetchdefault`,tempData,isloading);
            return res;
        }
        if(context.dstmicroservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/dstmicroservices/${context.dstmicroservice}/dstapis/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/dstapis/fetchdefault`,tempData,isloading);
        return res;
    }
}