package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[BladeVisualDTO]
 */
@Data
public class BladeVisualDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 属性 [TITLE]
     *
     */
    @JSONField(name = "title")
    @JsonProperty("title")
    @Size(min = 0, max = 255, message = "内容长度必须小于等于[255]")
    private String title;

    /**
     * 属性 [CATEGORY]
     *
     */
    @JSONField(name = "category")
    @JsonProperty("category")
    private Integer category;

    /**
     * 属性 [PASSWORD]
     *
     */
    @JSONField(name = "password")
    @JsonProperty("password")
    @Size(min = 0, max = 255, message = "内容长度必须小于等于[255]")
    private String password;

    /**
     * 属性 [BACKGROUND_URL]
     *
     */
    @JSONField(name = "backgroundUrl")
    @JsonProperty("backgroundUrl")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String backgroundurl;

    /**
     * 属性 [STATUS]
     *
     */
    @JSONField(name = "status")
    @JsonProperty("status")
    private Integer status;

    /**
     * 属性 [CREATE_TIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createTime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createTime")
    private Timestamp createtime;

    /**
     * 属性 [CREATE_DEPT]
     *
     */
    @JSONField(name = "createDept")
    @JsonProperty("createDept")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createdept;

    /**
     * 属性 [CREATE_USER]
     *
     */
    @JSONField(name = "createUser")
    @JsonProperty("createUser")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createuser;

    /**
     * 属性 [UPDATE_TIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updateTime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updateTime")
    private Timestamp updatetime;

    /**
     * 属性 [UPDATE_USER]
     *
     */
    @JSONField(name = "updateUser")
    @JsonProperty("updateUser")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long updateuser;

    /**
     * 属性 [IS_DELETED]
     *
     */
    @JSONField(name = "isDeleted")
    @JsonProperty("isDeleted")
    private Integer isdeleted;

    /**
     * 属性 [DETAIL]
     *
     */
    @JSONField(name = "detail")
    @JsonProperty("detail")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String detail;

    /**
     * 属性 [COMPONENT]
     *
     */
    @JSONField(name = "component")
    @JsonProperty("component")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String component;


    /**
     * 设置 [TITLE]
     */
    public void setTitle(String  title){
        this.title = title ;
        this.modify("title",title);
    }

    /**
     * 设置 [CATEGORY]
     */
    public void setCategory(Integer  category){
        this.category = category ;
        this.modify("category",category);
    }

    /**
     * 设置 [PASSWORD]
     */
    public void setPassword(String  password){
        this.password = password ;
        this.modify("password",password);
    }

    /**
     * 设置 [BACKGROUND_URL]
     */
    public void setBackgroundurl(String  backgroundurl){
        this.backgroundurl = backgroundurl ;
        this.modify("background_url",backgroundurl);
    }

    /**
     * 设置 [STATUS]
     */
    public void setStatus(Integer  status){
        this.status = status ;
        this.modify("status",status);
    }

    /**
     * 设置 [CREATE_DEPT]
     */
    public void setCreatedept(Long  createdept){
        this.createdept = createdept ;
        this.modify("create_dept",createdept);
    }

    /**
     * 设置 [CREATE_USER]
     */
    public void setCreateuser(Long  createuser){
        this.createuser = createuser ;
        this.modify("create_user",createuser);
    }

    /**
     * 设置 [UPDATE_USER]
     */
    public void setUpdateuser(Long  updateuser){
        this.updateuser = updateuser ;
        this.modify("update_user",updateuser);
    }


}


