package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.service.IMetaFieldService;
import cn.ibizlab.core.lite.filter.MetaFieldSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"属性" })
@RestController("api-metafield")
@RequestMapping("")
public class MetaFieldResource {

    @Autowired
    public IMetaFieldService metafieldService;

    @Autowired
    @Lazy
    public MetaFieldMapping metafieldMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Create-all')")
    @ApiOperation(value = "新建属性", tags = {"属性" },  notes = "新建属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metafields")
    public ResponseEntity<MetaFieldDTO> create(@Validated @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
		metafieldService.create(domain);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Create-all')")
    @ApiOperation(value = "批量新建属性", tags = {"属性" },  notes = "批量新建属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metafields/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<MetaFieldDTO> metafielddtos) {
        metafieldService.createBatch(metafieldMapping.toDomain(metafielddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "metafield" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Update-all')")
    @ApiOperation(value = "更新属性", tags = {"属性" },  notes = "更新属性")
	@RequestMapping(method = RequestMethod.PUT, value = "/metafields/{metafield_id}")
    public ResponseEntity<MetaFieldDTO> update(@PathVariable("metafield_id") String metafield_id, @RequestBody MetaFieldDTO metafielddto) {
		MetaField domain  = metafieldMapping.toDomain(metafielddto);
        domain .setFieldId(metafield_id);
		metafieldService.update(domain );
		MetaFieldDTO dto = metafieldMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Update-all')")
    @ApiOperation(value = "批量更新属性", tags = {"属性" },  notes = "批量更新属性")
	@RequestMapping(method = RequestMethod.PUT, value = "/metafields/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<MetaFieldDTO> metafielddtos) {
        metafieldService.updateBatch(metafieldMapping.toDomain(metafielddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Remove-all')")
    @ApiOperation(value = "删除属性", tags = {"属性" },  notes = "删除属性")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metafields/{metafield_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("metafield_id") String metafield_id) {
         return ResponseEntity.status(HttpStatus.OK).body(metafieldService.remove(metafield_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Remove-all')")
    @ApiOperation(value = "批量删除属性", tags = {"属性" },  notes = "批量删除属性")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metafields/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        metafieldService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Get-all')")
    @ApiOperation(value = "获取属性", tags = {"属性" },  notes = "获取属性")
	@RequestMapping(method = RequestMethod.GET, value = "/metafields/{metafield_id}")
    public ResponseEntity<MetaFieldDTO> get(@PathVariable("metafield_id") String metafield_id) {
        MetaField domain = metafieldService.get(metafield_id);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取属性草稿", tags = {"属性" },  notes = "获取属性草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/metafields/getdraft")
    public ResponseEntity<MetaFieldDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(metafieldMapping.toDto(metafieldService.getDraft(new MetaField())));
    }

    @ApiOperation(value = "检查属性", tags = {"属性" },  notes = "检查属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metafields/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody MetaFieldDTO metafielddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metafieldService.checkKey(metafieldMapping.toDomain(metafielddto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Save-all')")
    @ApiOperation(value = "保存属性", tags = {"属性" },  notes = "保存属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metafields/save")
    public ResponseEntity<Boolean> save(@RequestBody MetaFieldDTO metafielddto) {
        return ResponseEntity.status(HttpStatus.OK).body(metafieldService.save(metafieldMapping.toDomain(metafielddto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Save-all')")
    @ApiOperation(value = "批量保存属性", tags = {"属性" },  notes = "批量保存属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metafields/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<MetaFieldDTO> metafielddtos) {
        metafieldService.saveBatch(metafieldMapping.toDomain(metafielddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"属性" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/metafields/fetchdefault")
	public ResponseEntity<List<MetaFieldDTO>> fetchDefault(MetaFieldSearchContext context) {
        Page<MetaField> domains = metafieldService.searchDefault(context) ;
        List<MetaFieldDTO> list = metafieldMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"属性" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/metafields/searchdefault")
	public ResponseEntity<Page<MetaFieldDTO>> searchDefault(@RequestBody MetaFieldSearchContext context) {
        Page<MetaField> domains = metafieldService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metafieldMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Create-all')")
    @ApiOperation(value = "根据实体建立属性", tags = {"属性" },  notes = "根据实体建立属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metafields")
    public ResponseEntity<MetaFieldDTO> createByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
        domain.setEntityId(metaentity_id);
		metafieldService.create(domain);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Create-all')")
    @ApiOperation(value = "根据实体批量建立属性", tags = {"属性" },  notes = "根据实体批量建立属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metafields/batch")
    public ResponseEntity<Boolean> createBatchByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaFieldDTO> metafielddtos) {
        List<MetaField> domainlist=metafieldMapping.toDomain(metafielddtos);
        for(MetaField domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metafieldService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "metafield" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Update-all')")
    @ApiOperation(value = "根据实体更新属性", tags = {"属性" },  notes = "根据实体更新属性")
	@RequestMapping(method = RequestMethod.PUT, value = "/metaentities/{metaentity_id}/metafields/{metafield_id}")
    public ResponseEntity<MetaFieldDTO> updateByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @PathVariable("metafield_id") String metafield_id, @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
        domain.setEntityId(metaentity_id);
        domain.setFieldId(metafield_id);
		metafieldService.update(domain);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Update-all')")
    @ApiOperation(value = "根据实体批量更新属性", tags = {"属性" },  notes = "根据实体批量更新属性")
	@RequestMapping(method = RequestMethod.PUT, value = "/metaentities/{metaentity_id}/metafields/batch")
    public ResponseEntity<Boolean> updateBatchByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaFieldDTO> metafielddtos) {
        List<MetaField> domainlist=metafieldMapping.toDomain(metafielddtos);
        for(MetaField domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metafieldService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Remove-all')")
    @ApiOperation(value = "根据实体删除属性", tags = {"属性" },  notes = "根据实体删除属性")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metaentities/{metaentity_id}/metafields/{metafield_id}")
    public ResponseEntity<Boolean> removeByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @PathVariable("metafield_id") String metafield_id) {
		return ResponseEntity.status(HttpStatus.OK).body(metafieldService.remove(metafield_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Remove-all')")
    @ApiOperation(value = "根据实体批量删除属性", tags = {"属性" },  notes = "根据实体批量删除属性")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metaentities/{metaentity_id}/metafields/batch")
    public ResponseEntity<Boolean> removeBatchByMetaEntity(@RequestBody List<String> ids) {
        metafieldService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Get-all')")
    @ApiOperation(value = "根据实体获取属性", tags = {"属性" },  notes = "根据实体获取属性")
	@RequestMapping(method = RequestMethod.GET, value = "/metaentities/{metaentity_id}/metafields/{metafield_id}")
    public ResponseEntity<MetaFieldDTO> getByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @PathVariable("metafield_id") String metafield_id) {
        MetaField domain = metafieldService.get(metafield_id);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据实体获取属性草稿", tags = {"属性" },  notes = "根据实体获取属性草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/metaentities/{metaentity_id}/metafields/getdraft")
    public ResponseEntity<MetaFieldDTO> getDraftByMetaEntity(@PathVariable("metaentity_id") String metaentity_id) {
        MetaField domain = new MetaField();
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metafieldMapping.toDto(metafieldService.getDraft(domain)));
    }

    @ApiOperation(value = "根据实体检查属性", tags = {"属性" },  notes = "根据实体检查属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metafields/checkkey")
    public ResponseEntity<Boolean> checkKeyByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldDTO metafielddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metafieldService.checkKey(metafieldMapping.toDomain(metafielddto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Save-all')")
    @ApiOperation(value = "根据实体保存属性", tags = {"属性" },  notes = "根据实体保存属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metafields/save")
    public ResponseEntity<Boolean> saveByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metafieldService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Save-all')")
    @ApiOperation(value = "根据实体批量保存属性", tags = {"属性" },  notes = "根据实体批量保存属性")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metafields/savebatch")
    public ResponseEntity<Boolean> saveBatchByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaFieldDTO> metafielddtos) {
        List<MetaField> domainlist=metafieldMapping.toDomain(metafielddtos);
        for(MetaField domain:domainlist){
             domain.setEntityId(metaentity_id);
        }
        metafieldService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-searchDefault-all')")
	@ApiOperation(value = "根据实体获取数据集", tags = {"属性" } ,notes = "根据实体获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/metaentities/{metaentity_id}/metafields/fetchdefault")
	public ResponseEntity<List<MetaFieldDTO>> fetchMetaFieldDefaultByMetaEntity(@PathVariable("metaentity_id") String metaentity_id,MetaFieldSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaField> domains = metafieldService.searchDefault(context) ;
        List<MetaFieldDTO> list = metafieldMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-searchDefault-all')")
	@ApiOperation(value = "根据实体查询数据集", tags = {"属性" } ,notes = "根据实体查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/metaentities/{metaentity_id}/metafields/searchdefault")
	public ResponseEntity<Page<MetaFieldDTO>> searchMetaFieldDefaultByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaField> domains = metafieldService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metafieldMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Create-all')")
    @ApiOperation(value = "根据系统实体建立属性", tags = {"属性" },  notes = "根据系统实体建立属性")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields")
    public ResponseEntity<MetaFieldDTO> createByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
        domain.setEntityId(metaentity_id);
		metafieldService.create(domain);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Create-all')")
    @ApiOperation(value = "根据系统实体批量建立属性", tags = {"属性" },  notes = "根据系统实体批量建立属性")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/batch")
    public ResponseEntity<Boolean> createBatchByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaFieldDTO> metafielddtos) {
        List<MetaField> domainlist=metafieldMapping.toDomain(metafielddtos);
        for(MetaField domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metafieldService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "metafield" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Update-all')")
    @ApiOperation(value = "根据系统实体更新属性", tags = {"属性" },  notes = "根据系统实体更新属性")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/{metafield_id}")
    public ResponseEntity<MetaFieldDTO> updateByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @PathVariable("metafield_id") String metafield_id, @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
        domain.setEntityId(metaentity_id);
        domain.setFieldId(metafield_id);
		metafieldService.update(domain);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Update-all')")
    @ApiOperation(value = "根据系统实体批量更新属性", tags = {"属性" },  notes = "根据系统实体批量更新属性")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/batch")
    public ResponseEntity<Boolean> updateBatchByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaFieldDTO> metafielddtos) {
        List<MetaField> domainlist=metafieldMapping.toDomain(metafielddtos);
        for(MetaField domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metafieldService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Remove-all')")
    @ApiOperation(value = "根据系统实体删除属性", tags = {"属性" },  notes = "根据系统实体删除属性")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/{metafield_id}")
    public ResponseEntity<Boolean> removeByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @PathVariable("metafield_id") String metafield_id) {
		return ResponseEntity.status(HttpStatus.OK).body(metafieldService.remove(metafield_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Remove-all')")
    @ApiOperation(value = "根据系统实体批量删除属性", tags = {"属性" },  notes = "根据系统实体批量删除属性")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/batch")
    public ResponseEntity<Boolean> removeBatchByDstSystemMetaEntity(@RequestBody List<String> ids) {
        metafieldService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Get-all')")
    @ApiOperation(value = "根据系统实体获取属性", tags = {"属性" },  notes = "根据系统实体获取属性")
	@RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/{metafield_id}")
    public ResponseEntity<MetaFieldDTO> getByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @PathVariable("metafield_id") String metafield_id) {
        MetaField domain = metafieldService.get(metafield_id);
        MetaFieldDTO dto = metafieldMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统实体获取属性草稿", tags = {"属性" },  notes = "根据系统实体获取属性草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/getdraft")
    public ResponseEntity<MetaFieldDTO> getDraftByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id) {
        MetaField domain = new MetaField();
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metafieldMapping.toDto(metafieldService.getDraft(domain)));
    }

    @ApiOperation(value = "根据系统实体检查属性", tags = {"属性" },  notes = "根据系统实体检查属性")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldDTO metafielddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metafieldService.checkKey(metafieldMapping.toDomain(metafielddto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Save-all')")
    @ApiOperation(value = "根据系统实体保存属性", tags = {"属性" },  notes = "根据系统实体保存属性")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/save")
    public ResponseEntity<Boolean> saveByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldDTO metafielddto) {
        MetaField domain = metafieldMapping.toDomain(metafielddto);
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metafieldService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-Save-all')")
    @ApiOperation(value = "根据系统实体批量保存属性", tags = {"属性" },  notes = "根据系统实体批量保存属性")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaFieldDTO> metafielddtos) {
        List<MetaField> domainlist=metafieldMapping.toDomain(metafielddtos);
        for(MetaField domain:domainlist){
             domain.setEntityId(metaentity_id);
        }
        metafieldService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-searchDefault-all')")
	@ApiOperation(value = "根据系统实体获取数据集", tags = {"属性" } ,notes = "根据系统实体获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/fetchdefault")
	public ResponseEntity<List<MetaFieldDTO>> fetchMetaFieldDefaultByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id,MetaFieldSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaField> domains = metafieldService.searchDefault(context) ;
        List<MetaFieldDTO> list = metafieldMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaField-searchDefault-all')")
	@ApiOperation(value = "根据系统实体查询数据集", tags = {"属性" } ,notes = "根据系统实体查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metafields/searchdefault")
	public ResponseEntity<Page<MetaFieldDTO>> searchMetaFieldDefaultByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaFieldSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaField> domains = metafieldService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metafieldMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

