package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.lite.domain.MetaRelationship;
import cn.ibizlab.core.lite.service.IMetaRelationshipService;
import cn.ibizlab.core.lite.filter.MetaRelationshipSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"实体关系" })
@RestController("api-metarelationship")
@RequestMapping("")
public class MetaRelationshipResource {

    @Autowired
    public IMetaRelationshipService metarelationshipService;

    @Autowired
    @Lazy
    public MetaRelationshipMapping metarelationshipMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Create-all')")
    @ApiOperation(value = "新建实体关系", tags = {"实体关系" },  notes = "新建实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metarelationships")
    public ResponseEntity<MetaRelationshipDTO> create(@Validated @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
		metarelationshipService.create(domain);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Create-all')")
    @ApiOperation(value = "批量新建实体关系", tags = {"实体关系" },  notes = "批量新建实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metarelationships/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        metarelationshipService.createBatch(metarelationshipMapping.toDomain(metarelationshipdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "metarelationship" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Update-all')")
    @ApiOperation(value = "更新实体关系", tags = {"实体关系" },  notes = "更新实体关系")
	@RequestMapping(method = RequestMethod.PUT, value = "/metarelationships/{metarelationship_id}")
    public ResponseEntity<MetaRelationshipDTO> update(@PathVariable("metarelationship_id") String metarelationship_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
		MetaRelationship domain  = metarelationshipMapping.toDomain(metarelationshipdto);
        domain .setId(metarelationship_id);
		metarelationshipService.update(domain );
		MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Update-all')")
    @ApiOperation(value = "批量更新实体关系", tags = {"实体关系" },  notes = "批量更新实体关系")
	@RequestMapping(method = RequestMethod.PUT, value = "/metarelationships/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        metarelationshipService.updateBatch(metarelationshipMapping.toDomain(metarelationshipdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Remove-all')")
    @ApiOperation(value = "删除实体关系", tags = {"实体关系" },  notes = "删除实体关系")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metarelationships/{metarelationship_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("metarelationship_id") String metarelationship_id) {
         return ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.remove(metarelationship_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Remove-all')")
    @ApiOperation(value = "批量删除实体关系", tags = {"实体关系" },  notes = "批量删除实体关系")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metarelationships/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        metarelationshipService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Get-all')")
    @ApiOperation(value = "获取实体关系", tags = {"实体关系" },  notes = "获取实体关系")
	@RequestMapping(method = RequestMethod.GET, value = "/metarelationships/{metarelationship_id}")
    public ResponseEntity<MetaRelationshipDTO> get(@PathVariable("metarelationship_id") String metarelationship_id) {
        MetaRelationship domain = metarelationshipService.get(metarelationship_id);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取实体关系草稿", tags = {"实体关系" },  notes = "获取实体关系草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/metarelationships/getdraft")
    public ResponseEntity<MetaRelationshipDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(metarelationshipMapping.toDto(metarelationshipService.getDraft(new MetaRelationship())));
    }

    @ApiOperation(value = "检查实体关系", tags = {"实体关系" },  notes = "检查实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metarelationships/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody MetaRelationshipDTO metarelationshipdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.checkKey(metarelationshipMapping.toDomain(metarelationshipdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Save-all')")
    @ApiOperation(value = "保存实体关系", tags = {"实体关系" },  notes = "保存实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metarelationships/save")
    public ResponseEntity<Boolean> save(@RequestBody MetaRelationshipDTO metarelationshipdto) {
        return ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.save(metarelationshipMapping.toDomain(metarelationshipdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Save-all')")
    @ApiOperation(value = "批量保存实体关系", tags = {"实体关系" },  notes = "批量保存实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metarelationships/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        metarelationshipService.saveBatch(metarelationshipMapping.toDomain(metarelationshipdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"实体关系" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/metarelationships/fetchdefault")
	public ResponseEntity<List<MetaRelationshipDTO>> fetchDefault(MetaRelationshipSearchContext context) {
        Page<MetaRelationship> domains = metarelationshipService.searchDefault(context) ;
        List<MetaRelationshipDTO> list = metarelationshipMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"实体关系" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/metarelationships/searchdefault")
	public ResponseEntity<Page<MetaRelationshipDTO>> searchDefault(@RequestBody MetaRelationshipSearchContext context) {
        Page<MetaRelationship> domains = metarelationshipService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metarelationshipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Create-all')")
    @ApiOperation(value = "根据实体建立实体关系", tags = {"实体关系" },  notes = "根据实体建立实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metarelationships")
    public ResponseEntity<MetaRelationshipDTO> createByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
        domain.setEntityId(metaentity_id);
		metarelationshipService.create(domain);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Create-all')")
    @ApiOperation(value = "根据实体批量建立实体关系", tags = {"实体关系" },  notes = "根据实体批量建立实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metarelationships/batch")
    public ResponseEntity<Boolean> createBatchByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        List<MetaRelationship> domainlist=metarelationshipMapping.toDomain(metarelationshipdtos);
        for(MetaRelationship domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metarelationshipService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "metarelationship" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Update-all')")
    @ApiOperation(value = "根据实体更新实体关系", tags = {"实体关系" },  notes = "根据实体更新实体关系")
	@RequestMapping(method = RequestMethod.PUT, value = "/metaentities/{metaentity_id}/metarelationships/{metarelationship_id}")
    public ResponseEntity<MetaRelationshipDTO> updateByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @PathVariable("metarelationship_id") String metarelationship_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
        domain.setEntityId(metaentity_id);
        domain.setId(metarelationship_id);
		metarelationshipService.update(domain);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Update-all')")
    @ApiOperation(value = "根据实体批量更新实体关系", tags = {"实体关系" },  notes = "根据实体批量更新实体关系")
	@RequestMapping(method = RequestMethod.PUT, value = "/metaentities/{metaentity_id}/metarelationships/batch")
    public ResponseEntity<Boolean> updateBatchByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        List<MetaRelationship> domainlist=metarelationshipMapping.toDomain(metarelationshipdtos);
        for(MetaRelationship domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metarelationshipService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Remove-all')")
    @ApiOperation(value = "根据实体删除实体关系", tags = {"实体关系" },  notes = "根据实体删除实体关系")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metaentities/{metaentity_id}/metarelationships/{metarelationship_id}")
    public ResponseEntity<Boolean> removeByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @PathVariable("metarelationship_id") String metarelationship_id) {
		return ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.remove(metarelationship_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Remove-all')")
    @ApiOperation(value = "根据实体批量删除实体关系", tags = {"实体关系" },  notes = "根据实体批量删除实体关系")
	@RequestMapping(method = RequestMethod.DELETE, value = "/metaentities/{metaentity_id}/metarelationships/batch")
    public ResponseEntity<Boolean> removeBatchByMetaEntity(@RequestBody List<String> ids) {
        metarelationshipService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Get-all')")
    @ApiOperation(value = "根据实体获取实体关系", tags = {"实体关系" },  notes = "根据实体获取实体关系")
	@RequestMapping(method = RequestMethod.GET, value = "/metaentities/{metaentity_id}/metarelationships/{metarelationship_id}")
    public ResponseEntity<MetaRelationshipDTO> getByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @PathVariable("metarelationship_id") String metarelationship_id) {
        MetaRelationship domain = metarelationshipService.get(metarelationship_id);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据实体获取实体关系草稿", tags = {"实体关系" },  notes = "根据实体获取实体关系草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/metaentities/{metaentity_id}/metarelationships/getdraft")
    public ResponseEntity<MetaRelationshipDTO> getDraftByMetaEntity(@PathVariable("metaentity_id") String metaentity_id) {
        MetaRelationship domain = new MetaRelationship();
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metarelationshipMapping.toDto(metarelationshipService.getDraft(domain)));
    }

    @ApiOperation(value = "根据实体检查实体关系", tags = {"实体关系" },  notes = "根据实体检查实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metarelationships/checkkey")
    public ResponseEntity<Boolean> checkKeyByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.checkKey(metarelationshipMapping.toDomain(metarelationshipdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Save-all')")
    @ApiOperation(value = "根据实体保存实体关系", tags = {"实体关系" },  notes = "根据实体保存实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metarelationships/save")
    public ResponseEntity<Boolean> saveByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Save-all')")
    @ApiOperation(value = "根据实体批量保存实体关系", tags = {"实体关系" },  notes = "根据实体批量保存实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/metaentities/{metaentity_id}/metarelationships/savebatch")
    public ResponseEntity<Boolean> saveBatchByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        List<MetaRelationship> domainlist=metarelationshipMapping.toDomain(metarelationshipdtos);
        for(MetaRelationship domain:domainlist){
             domain.setEntityId(metaentity_id);
        }
        metarelationshipService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-searchDefault-all')")
	@ApiOperation(value = "根据实体获取数据集", tags = {"实体关系" } ,notes = "根据实体获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/metaentities/{metaentity_id}/metarelationships/fetchdefault")
	public ResponseEntity<List<MetaRelationshipDTO>> fetchMetaRelationshipDefaultByMetaEntity(@PathVariable("metaentity_id") String metaentity_id,MetaRelationshipSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaRelationship> domains = metarelationshipService.searchDefault(context) ;
        List<MetaRelationshipDTO> list = metarelationshipMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-searchDefault-all')")
	@ApiOperation(value = "根据实体查询数据集", tags = {"实体关系" } ,notes = "根据实体查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/metaentities/{metaentity_id}/metarelationships/searchdefault")
	public ResponseEntity<Page<MetaRelationshipDTO>> searchMetaRelationshipDefaultByMetaEntity(@PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaRelationship> domains = metarelationshipService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metarelationshipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Create-all')")
    @ApiOperation(value = "根据系统实体建立实体关系", tags = {"实体关系" },  notes = "根据系统实体建立实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships")
    public ResponseEntity<MetaRelationshipDTO> createByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
        domain.setEntityId(metaentity_id);
		metarelationshipService.create(domain);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Create-all')")
    @ApiOperation(value = "根据系统实体批量建立实体关系", tags = {"实体关系" },  notes = "根据系统实体批量建立实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/batch")
    public ResponseEntity<Boolean> createBatchByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        List<MetaRelationship> domainlist=metarelationshipMapping.toDomain(metarelationshipdtos);
        for(MetaRelationship domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metarelationshipService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "metarelationship" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Update-all')")
    @ApiOperation(value = "根据系统实体更新实体关系", tags = {"实体关系" },  notes = "根据系统实体更新实体关系")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/{metarelationship_id}")
    public ResponseEntity<MetaRelationshipDTO> updateByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @PathVariable("metarelationship_id") String metarelationship_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
        domain.setEntityId(metaentity_id);
        domain.setId(metarelationship_id);
		metarelationshipService.update(domain);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Update-all')")
    @ApiOperation(value = "根据系统实体批量更新实体关系", tags = {"实体关系" },  notes = "根据系统实体批量更新实体关系")
	@RequestMapping(method = RequestMethod.PUT, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/batch")
    public ResponseEntity<Boolean> updateBatchByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        List<MetaRelationship> domainlist=metarelationshipMapping.toDomain(metarelationshipdtos);
        for(MetaRelationship domain:domainlist){
            domain.setEntityId(metaentity_id);
        }
        metarelationshipService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Remove-all')")
    @ApiOperation(value = "根据系统实体删除实体关系", tags = {"实体关系" },  notes = "根据系统实体删除实体关系")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/{metarelationship_id}")
    public ResponseEntity<Boolean> removeByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @PathVariable("metarelationship_id") String metarelationship_id) {
		return ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.remove(metarelationship_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Remove-all')")
    @ApiOperation(value = "根据系统实体批量删除实体关系", tags = {"实体关系" },  notes = "根据系统实体批量删除实体关系")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/batch")
    public ResponseEntity<Boolean> removeBatchByDstSystemMetaEntity(@RequestBody List<String> ids) {
        metarelationshipService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Get-all')")
    @ApiOperation(value = "根据系统实体获取实体关系", tags = {"实体关系" },  notes = "根据系统实体获取实体关系")
	@RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/{metarelationship_id}")
    public ResponseEntity<MetaRelationshipDTO> getByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @PathVariable("metarelationship_id") String metarelationship_id) {
        MetaRelationship domain = metarelationshipService.get(metarelationship_id);
        MetaRelationshipDTO dto = metarelationshipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据系统实体获取实体关系草稿", tags = {"实体关系" },  notes = "根据系统实体获取实体关系草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/getdraft")
    public ResponseEntity<MetaRelationshipDTO> getDraftByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id) {
        MetaRelationship domain = new MetaRelationship();
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metarelationshipMapping.toDto(metarelationshipService.getDraft(domain)));
    }

    @ApiOperation(value = "根据系统实体检查实体关系", tags = {"实体关系" },  notes = "根据系统实体检查实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/checkkey")
    public ResponseEntity<Boolean> checkKeyByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.checkKey(metarelationshipMapping.toDomain(metarelationshipdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Save-all')")
    @ApiOperation(value = "根据系统实体保存实体关系", tags = {"实体关系" },  notes = "根据系统实体保存实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/save")
    public ResponseEntity<Boolean> saveByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipDTO metarelationshipdto) {
        MetaRelationship domain = metarelationshipMapping.toDomain(metarelationshipdto);
        domain.setEntityId(metaentity_id);
        return ResponseEntity.status(HttpStatus.OK).body(metarelationshipService.save(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-Save-all')")
    @ApiOperation(value = "根据系统实体批量保存实体关系", tags = {"实体关系" },  notes = "根据系统实体批量保存实体关系")
	@RequestMapping(method = RequestMethod.POST, value = "/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/savebatch")
    public ResponseEntity<Boolean> saveBatchByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody List<MetaRelationshipDTO> metarelationshipdtos) {
        List<MetaRelationship> domainlist=metarelationshipMapping.toDomain(metarelationshipdtos);
        for(MetaRelationship domain:domainlist){
             domain.setEntityId(metaentity_id);
        }
        metarelationshipService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-searchDefault-all')")
	@ApiOperation(value = "根据系统实体获取数据集", tags = {"实体关系" } ,notes = "根据系统实体获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/fetchdefault")
	public ResponseEntity<List<MetaRelationshipDTO>> fetchMetaRelationshipDefaultByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id,MetaRelationshipSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaRelationship> domains = metarelationshipService.searchDefault(context) ;
        List<MetaRelationshipDTO> list = metarelationshipMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-MetaRelationship-searchDefault-all')")
	@ApiOperation(value = "根据系统实体查询数据集", tags = {"实体关系" } ,notes = "根据系统实体查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dstsystems/{dstsystem_id}/metaentities/{metaentity_id}/metarelationships/searchdefault")
	public ResponseEntity<Page<MetaRelationshipDTO>> searchMetaRelationshipDefaultByDstSystemMetaEntity(@PathVariable("dstsystem_id") String dstsystem_id, @PathVariable("metaentity_id") String metaentity_id, @RequestBody MetaRelationshipSearchContext context) {
        context.setN_entityid_eq(metaentity_id);
        Page<MetaRelationship> domains = metarelationshipService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(metarelationshipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

