package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DstRouterDTO]
 */
@Data
public class DstRouterDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ROUTERID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [ROUTERNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String name;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;

    /**
     * 属性 [APPID]
     *
     */
    @JSONField(name = "app_id")
    @JsonProperty("app_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String appId;

    /**
     * 属性 [ROUTERPATH]
     *
     */
    @JSONField(name = "path")
    @JsonProperty("path")
    @Size(min = 0, max = 255, message = "内容长度必须小于等于[255]")
    private String path;

    /**
     * 属性 [PARENTID]
     *
     */
    @JSONField(name = "parentid")
    @JsonProperty("parentid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String parentid;

    /**
     * 属性 [META]
     *
     */
    @JSONField(name = "meta")
    @JsonProperty("meta")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String meta;

    /**
     * 属性 [COMPONENT]
     *
     */
    @JSONField(name = "component")
    @JsonProperty("component")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String component;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;


    /**
     * 设置 [ROUTERNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("routername",name);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }

    /**
     * 设置 [APPID]
     */
    public void setAppId(String  appId){
        this.appId = appId ;
        this.modify("appid",appId);
    }

    /**
     * 设置 [ROUTERPATH]
     */
    public void setPath(String  path){
        this.path = path ;
        this.modify("routerpath",path);
    }

    /**
     * 设置 [PARENTID]
     */
    public void setParentid(String  parentid){
        this.parentid = parentid ;
        this.modify("parentid",parentid);
    }

    /**
     * 设置 [META]
     */
    public void setMeta(String  meta){
        this.meta = meta ;
        this.modify("meta",meta);
    }

    /**
     * 设置 [COMPONENT]
     */
    public void setComponent(String  component){
        this.component = component ;
        this.modify("component",component);
    }


}


