package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.avuedata.domain.BladeVisualCategory;
import cn.ibizlab.core.avuedata.service.IBladeVisualCategoryService;
import cn.ibizlab.core.avuedata.filter.BladeVisualCategorySearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"可视化分类表" })
@RestController("api-bladevisualcategory")
@RequestMapping("")
public class BladeVisualCategoryResource {

    @Autowired
    public IBladeVisualCategoryService bladevisualcategoryService;

    @Autowired
    @Lazy
    public BladeVisualCategoryMapping bladevisualcategoryMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Create-all')")
    @ApiOperation(value = "新建可视化分类表", tags = {"可视化分类表" },  notes = "新建可视化分类表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualcategories")
    public ResponseEntity<BladeVisualCategoryDTO> create(@Validated @RequestBody BladeVisualCategoryDTO bladevisualcategorydto) {
        BladeVisualCategory domain = bladevisualcategoryMapping.toDomain(bladevisualcategorydto);
		bladevisualcategoryService.create(domain);
        BladeVisualCategoryDTO dto = bladevisualcategoryMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Create-all')")
    @ApiOperation(value = "批量新建可视化分类表", tags = {"可视化分类表" },  notes = "批量新建可视化分类表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualcategories/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<BladeVisualCategoryDTO> bladevisualcategorydtos) {
        bladevisualcategoryService.createBatch(bladevisualcategoryMapping.toDomain(bladevisualcategorydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Update-all')")
    @ApiOperation(value = "更新可视化分类表", tags = {"可视化分类表" },  notes = "更新可视化分类表")
	@RequestMapping(method = RequestMethod.PUT, value = "/bladevisualcategories/{bladevisualcategory_id}")
    public ResponseEntity<BladeVisualCategoryDTO> update(@PathVariable("bladevisualcategory_id") Long bladevisualcategory_id, @RequestBody BladeVisualCategoryDTO bladevisualcategorydto) {
		BladeVisualCategory domain  = bladevisualcategoryMapping.toDomain(bladevisualcategorydto);
        domain .setId(bladevisualcategory_id);
		bladevisualcategoryService.update(domain );
		BladeVisualCategoryDTO dto = bladevisualcategoryMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Update-all')")
    @ApiOperation(value = "批量更新可视化分类表", tags = {"可视化分类表" },  notes = "批量更新可视化分类表")
	@RequestMapping(method = RequestMethod.PUT, value = "/bladevisualcategories/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<BladeVisualCategoryDTO> bladevisualcategorydtos) {
        bladevisualcategoryService.updateBatch(bladevisualcategoryMapping.toDomain(bladevisualcategorydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Remove-all')")
    @ApiOperation(value = "删除可视化分类表", tags = {"可视化分类表" },  notes = "删除可视化分类表")
	@RequestMapping(method = RequestMethod.DELETE, value = "/bladevisualcategories/{bladevisualcategory_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("bladevisualcategory_id") Long bladevisualcategory_id) {
         return ResponseEntity.status(HttpStatus.OK).body(bladevisualcategoryService.remove(bladevisualcategory_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Remove-all')")
    @ApiOperation(value = "批量删除可视化分类表", tags = {"可视化分类表" },  notes = "批量删除可视化分类表")
	@RequestMapping(method = RequestMethod.DELETE, value = "/bladevisualcategories/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<Long> ids) {
        bladevisualcategoryService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Get-all')")
    @ApiOperation(value = "获取可视化分类表", tags = {"可视化分类表" },  notes = "获取可视化分类表")
	@RequestMapping(method = RequestMethod.GET, value = "/bladevisualcategories/{bladevisualcategory_id}")
    public ResponseEntity<BladeVisualCategoryDTO> get(@PathVariable("bladevisualcategory_id") Long bladevisualcategory_id) {
        BladeVisualCategory domain = bladevisualcategoryService.get(bladevisualcategory_id);
        BladeVisualCategoryDTO dto = bladevisualcategoryMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取可视化分类表草稿", tags = {"可视化分类表" },  notes = "获取可视化分类表草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/bladevisualcategories/getdraft")
    public ResponseEntity<BladeVisualCategoryDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(bladevisualcategoryMapping.toDto(bladevisualcategoryService.getDraft(new BladeVisualCategory())));
    }

    @ApiOperation(value = "检查可视化分类表", tags = {"可视化分类表" },  notes = "检查可视化分类表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualcategories/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody BladeVisualCategoryDTO bladevisualcategorydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(bladevisualcategoryService.checkKey(bladevisualcategoryMapping.toDomain(bladevisualcategorydto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Save-all')")
    @ApiOperation(value = "保存可视化分类表", tags = {"可视化分类表" },  notes = "保存可视化分类表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualcategories/save")
    public ResponseEntity<Boolean> save(@RequestBody BladeVisualCategoryDTO bladevisualcategorydto) {
        return ResponseEntity.status(HttpStatus.OK).body(bladevisualcategoryService.save(bladevisualcategoryMapping.toDomain(bladevisualcategorydto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-Save-all')")
    @ApiOperation(value = "批量保存可视化分类表", tags = {"可视化分类表" },  notes = "批量保存可视化分类表")
	@RequestMapping(method = RequestMethod.POST, value = "/bladevisualcategories/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<BladeVisualCategoryDTO> bladevisualcategorydtos) {
        bladevisualcategoryService.saveBatch(bladevisualcategoryMapping.toDomain(bladevisualcategorydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"可视化分类表" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/bladevisualcategories/fetchdefault")
	public ResponseEntity<List<BladeVisualCategoryDTO>> fetchDefault(BladeVisualCategorySearchContext context) {
        Page<BladeVisualCategory> domains = bladevisualcategoryService.searchDefault(context) ;
        List<BladeVisualCategoryDTO> list = bladevisualcategoryMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzlite-BladeVisualCategory-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"可视化分类表" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/bladevisualcategories/searchdefault")
	public ResponseEntity<Page<BladeVisualCategoryDTO>> searchDefault(@RequestBody BladeVisualCategorySearchContext context) {
        Page<BladeVisualCategory> domains = bladevisualcategoryService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(bladevisualcategoryMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

