/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'entityname',
          prop: 'entity_name',
          dataType: 'TEXT',
        },
        {
          name: 'codename',
          prop: 'code_name',
          dataType: 'TEXT',
        },
        {
          name: 'logicname',
          prop: 'logic_name',
          dataType: 'TEXT',
        },
        {
          name: 'tablename',
          prop: 'table_name',
          dataType: 'TEXT',
        },
        {
          name: 'dsname',
          prop: 'ds_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'systemname',
          prop: 'system_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfkey',
          prop: 'entity_id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'entity_id',
          dataType: 'TEXT',
        },
        {
          name: 'systemid',
          prop: 'system_id',
          dataType: 'PICKUP',
        },
        {
          name: 'dsid',
          prop: 'ds_id',
          dataType: 'PICKUP',
        },
        {
          name: 'moduleid',
          prop: 'module_id',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'entity_name',
          dataType: 'TEXT',
        },
        {
          name: 'metaentity',
          prop: 'entity_id',
        },
      {
        name: 'n_logicname_like',
        prop: 'n_logicname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_entityname_like',
        prop: 'n_entityname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_codename_eq',
        prop: 'n_codename_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_tablename_like',
        prop: 'n_tablename_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_dsname_like',
        prop: 'n_dsname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
        // 预置工作流数据字段
        {
          name: 'srfprocessdefinitionkey',
          prop: 'srfprocessdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskdefinitionkey',
          prop: 'srftaskdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskid',
          prop: 'srftaskid',
          dataType: 'TEXT'
        }
      ]
    }
  }

}