import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import UtilService from '@/utilservice/util-service';
import DstIndexModel from './dst-index-appmenu-model';


/**
 * DstIndex 部件服务对象
 *
 * @export
 * @class DstIndexService
 */
export default class DstIndexService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof DstIndexService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * 工具服务对象
     *
     * @protected
     * @type {UtilService}
     * @memberof DstIndexService
     */
    protected utilService: UtilService = new UtilService();

    /**
     * Creates an instance of DstIndexService.
     * 
     * @param {*} [opts={}]
     * @memberof DstIndexService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new DstIndexModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof DstIndex
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/dst-indexappmenu', params);
    }

}