import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'

// 获取全部数组
mock.onGet('./assets/json/data-dictionary.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, [
        {
        srfkey: "AppType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "INNER",
                label: "内置应用",
                text: "内置应用",
                "class":"",
                "data":"",
                "codename":"Inner",
                value: "INNER",
                
                disabled: false,
            },
            {
                id: "THIRD-PARTY",
                label: "第三方应用",
                text: "第三方应用",
                "class":"",
                "data":"",
                "codename":"Third_SUB_party",
                value: "THIRD-PARTY",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CLExtOP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "YOY",
                label: "同比",
                text: "同比",
                "class":"",
                "data":"",
                "codename":"Yoy",
                value: "YOY",
                
                disabled: false,
            },
            {
                id: "MOM",
                label: "环比",
                text: "环比",
                "class":"",
                "data":"",
                "codename":"Mom",
                value: "MOM",
                
                disabled: false,
            },
            {
                id: "Y3",
                label: "3年定基比",
                text: "3年定基比",
                "class":"",
                "data":"",
                "codename":"Y3",
                value: "Y3",
                
                disabled: false,
            },
            {
                id: "PER",
                label: "占比",
                text: "占比",
                "class":"",
                "data":"",
                "codename":"Per",
                value: "PER",
                
                disabled: false,
            },
            {
                id: "PER_ORI",
                label: "占比（原始值）",
                text: "占比（原始值）",
                "class":"",
                "data":"",
                "codename":"Per_ori",
                value: "PER_ORI",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "CLMetric",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"DAMetric",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: "CLMetricType",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "COUNT",
                label: "COUNT",
                text: "COUNT",
                "class":"",
                "data":"",
                "codename":"Count",
                value: "COUNT",
                
                disabled: false,
            },
            {
                id: "COUNT_DISTINCT",
                label: "COUNT_DISTINCT",
                text: "COUNT_DISTINCT",
                "class":"",
                "data":"",
                "codename":"Count_distinct",
                value: "COUNT_DISTINCT",
                
                disabled: false,
            },
            {
                id: "SUM",
                label: "SUM",
                text: "SUM",
                "class":"",
                "data":"",
                "codename":"Sum",
                value: "SUM",
                
                disabled: false,
            },
            {
                id: "AVG",
                label: "AVG",
                text: "AVG",
                "class":"",
                "data":"",
                "codename":"Avg",
                value: "AVG",
                
                disabled: false,
            },
            {
                id: "MAX",
                label: "MAX",
                text: "MAX",
                "class":"",
                "data":"",
                "codename":"Max",
                value: "MAX",
                
                disabled: false,
            },
            {
                id: "MIN",
                label: "MIN",
                text: "MIN",
                "class":"",
                "data":"",
                "codename":"Min",
                value: "MIN",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "CLModel",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"DABuild",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "CLRuleGroup",
        "emptytext": "",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        "srfkey": "DstDataSourceList",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"DstDataSource",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        "srfkey": "DstSystemList",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"DstSystem",
        "appdedataset":"FetchDefault",
        "items": []
    },
    {
        srfkey: "OPCond",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "EQ",
                label: "等于",
                text: "等于",
                "class":"",
                "data":"",
                "codename":"Eq",
                value: "EQ",
                
                disabled: false,
            },
            {
                id: "NOTEQ",
                label: "不等于",
                text: "不等于",
                "class":"",
                "data":"",
                "codename":"Noteq",
                value: "NOTEQ",
                
                disabled: false,
            },
            {
                id: "GTANDEQ",
                label: ">=",
                text: ">=",
                "class":"",
                "data":"",
                "codename":"Gtandeq",
                value: "GTANDEQ",
                
                disabled: false,
            },
            {
                id: "GT",
                label: ">",
                text: ">",
                "class":"",
                "data":"",
                "codename":"Gt",
                value: "GT",
                
                disabled: false,
            },
            {
                id: "LTANDEQ",
                label: "<=",
                text: "<=",
                "class":"",
                "data":"",
                "codename":"Ltandeq",
                value: "LTANDEQ",
                
                disabled: false,
            },
            {
                id: "LT",
                label: "<",
                text: "<",
                "class":"",
                "data":"",
                "codename":"Lt",
                value: "LT",
                
                disabled: false,
            },
            {
                id: "ISNULL",
                label: "为空",
                text: "为空",
                "class":"",
                "data":"",
                "codename":"Isnull",
                value: "ISNULL",
                
                disabled: false,
            },
            {
                id: "ISNOTNULL",
                label: "不为空",
                text: "不为空",
                "class":"",
                "data":"",
                "codename":"Isnotnull",
                value: "ISNOTNULL",
                
                disabled: false,
            },
            {
                id: "LIKE",
                label: "like",
                text: "like",
                "class":"",
                "data":"",
                "codename":"Like",
                value: "LIKE",
                
                disabled: false,
            },
            {
                id: "NOTLIKE",
                label: "not like",
                text: "not like",
                "class":"",
                "data":"",
                "codename":"Notlike",
                value: "NOTLIKE",
                
                disabled: false,
            },
            {
                id: "LEFTLIKE",
                label: "开头like",
                text: "开头like",
                "class":"",
                "data":"",
                "codename":"Leftlike",
                value: "LEFTLIKE",
                
                disabled: false,
            },
            {
                id: "LEFTNOTLIKE",
                label: "开头not like",
                text: "开头not like",
                "class":"",
                "data":"",
                "codename":"Leftnotlike",
                value: "LEFTNOTLIKE",
                
                disabled: false,
            },
            {
                id: "RIGHTLIKE",
                label: "结尾like",
                text: "结尾like",
                "class":"",
                "data":"",
                "codename":"Rightlike",
                value: "RIGHTLIKE",
                
                disabled: false,
            },
            {
                id: "RIGHTNOTLIKE",
                label: "结尾not like",
                text: "结尾not like",
                "class":"",
                "data":"",
                "codename":"Rightnotlike",
                value: "RIGHTNOTLIKE",
                
                disabled: false,
            },
            {
                id: "IN",
                label: "在范围中",
                text: "在范围中",
                "class":"",
                "data":"",
                "codename":"In",
                value: "IN",
                
                disabled: false,
            },
            {
                id: "NOTIN",
                label: "不在范围中",
                text: "不在范围中",
                "class":"",
                "data":"",
                "codename":"Notin",
                value: "NOTIN",
                
                disabled: false,
            },
            {
                id: "MATCHES",
                label: "MATCHES",
                text: "MATCHES",
                "class":"",
                "data":"",
                "codename":"Matches",
                value: "MATCHES",
                
                disabled: false,
            },
            {
                id: "NOTMATCHES",
                label: "NOT MATCHES",
                text: "NOT MATCHES",
                "class":"",
                "data":"",
                "codename":"Notmatches",
                value: "NOTMATCHES",
                
                disabled: false,
            },
            {
                id: "INC2S",
                label: "INC2S",
                text: "INC2S",
                "class":"",
                "data":"",
                "codename":"Inc2s",
                value: "INC2S",
                
                disabled: false,
            },
            {
                id: "NOTINC2S",
                label: "NOTINC2S",
                text: "NOTINC2S",
                "class":"",
                "data":"",
                "codename":"Notinc2s",
                value: "NOTINC2S",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "YesNo",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "是",
                text: "是",
                "class":"",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "0",
                label: "否",
                text: "否",
                "class":"",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
        ]
    }
    ]];
});

