/**
 * UI服务注册中心
 *
 * @export
 * @class UIServiceRegister
 */
export class UIServiceRegister {

    /**
     * 所有UI实体服务Map
     *
     * @protected
     * @type {*}
     * @memberof UIServiceRegister
     */
    protected allUIService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载UI实体服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof UIServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of UIServiceRegister.
     * @memberof UIServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UIServiceRegister
     */
    protected init(): void {
                this.allUIService.set('dadimension', () => import('@/uiservice/dadimension/dadimension-ui-service'));
        this.allUIService.set('dstsystem', () => import('@/uiservice/dst-system/dst-system-ui-service'));
        this.allUIService.set('dstapp', () => import('@/uiservice/dst-app/dst-app-ui-service'));
        this.allUIService.set('dareport', () => import('@/uiservice/dareport/dareport-ui-service'));
        this.allUIService.set('metadataset', () => import('@/uiservice/meta-data-set/meta-data-set-ui-service'));
        this.allUIService.set('ruleitem', () => import('@/uiservice/rule-item/rule-item-ui-service'));
        this.allUIService.set('dachart', () => import('@/uiservice/dachart/dachart-ui-service'));
        this.allUIService.set('dabuild', () => import('@/uiservice/dabuild/dabuild-ui-service'));
        this.allUIService.set('dstdatasource', () => import('@/uiservice/dst-data-source/dst-data-source-ui-service'));
        this.allUIService.set('metafield', () => import('@/uiservice/meta-field/meta-field-ui-service'));
        this.allUIService.set('execlog', () => import('@/uiservice/exec-log/exec-log-ui-service'));
        this.allUIService.set('dictcatalog', () => import('@/uiservice/dict-catalog/dict-catalog-ui-service'));
        this.allUIService.set('execresult', () => import('@/uiservice/exec-result/exec-result-ui-service'));
        this.allUIService.set('metarelationship', () => import('@/uiservice/meta-relationship/meta-relationship-ui-service'));
        this.allUIService.set('dametric', () => import('@/uiservice/dametric/dametric-ui-service'));
        this.allUIService.set('tablesync', () => import('@/uiservice/table-sync/table-sync-ui-service'));
        this.allUIService.set('ruleengine', () => import('@/uiservice/rule-engine/rule-engine-ui-service'));
        this.allUIService.set('metaentity', () => import('@/uiservice/meta-entity/meta-entity-ui-service'));
        this.allUIService.set('dictoption', () => import('@/uiservice/dict-option/dict-option-ui-service'));
        this.allUIService.set('metamodule', () => import('@/uiservice/meta-module/meta-module-ui-service'));
        this.allUIService.set('metamodel', () => import('@/uiservice/meta-model/meta-model-ui-service'));
    }

    /**
     * 加载服务实体
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allUIService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const uiServiceRegister: UIServiceRegister = new UIServiceRegister();