package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[MetaRelationshipDTO]
 */
@Data
public class MetaRelationshipDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [RELATIONID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [RELATIONNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @NotBlank(message = "[关系名称]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String name;

    /**
     * 属性 [RELTYPE]
     *
     */
    @JSONField(name = "relation_type")
    @JsonProperty("relation_type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String relationType;

    /**
     * 属性 [CODENAME]
     *
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String codeName;

    /**
     * 属性 [ENTITYID]
     *
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String entityId;

    /**
     * 属性 [ENTITYNAME]
     *
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String entityName;

    /**
     * 属性 [REFENTITYID]
     *
     */
    @JSONField(name = "ref_entity_id")
    @JsonProperty("ref_entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String refEntityId;

    /**
     * 属性 [REFENTITYNAME]
     *
     */
    @JSONField(name = "ref_entity_name")
    @JsonProperty("ref_entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String refEntityName;

    /**
     * 属性 [NESTEDNAME]
     *
     */
    @JSONField(name = "nested_name")
    @JsonProperty("nested_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String nestedName;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;


    /**
     * 设置 [RELATIONNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("relationname",name);
    }

    /**
     * 设置 [RELTYPE]
     */
    public void setRelationType(String  relationType){
        this.relationType = relationType ;
        this.modify("reltype",relationType);
    }

    /**
     * 设置 [CODENAME]
     */
    public void setCodeName(String  codeName){
        this.codeName = codeName ;
        this.modify("codename",codeName);
    }

    /**
     * 设置 [ENTITYID]
     */
    public void setEntityId(String  entityId){
        this.entityId = entityId ;
        this.modify("entityid",entityId);
    }

    /**
     * 设置 [ENTITYNAME]
     */
    public void setEntityName(String  entityName){
        this.entityName = entityName ;
        this.modify("entityname",entityName);
    }

    /**
     * 设置 [REFENTITYID]
     */
    public void setRefEntityId(String  refEntityId){
        this.refEntityId = refEntityId ;
        this.modify("refentityid",refEntityId);
    }

    /**
     * 设置 [REFENTITYNAME]
     */
    public void setRefEntityName(String  refEntityName){
        this.refEntityName = refEntityName ;
        this.modify("refentityname",refEntityName);
    }

    /**
     * 设置 [NESTEDNAME]
     */
    public void setNestedName(String  nestedName){
        this.nestedName = nestedName ;
        this.modify("nestedname",nestedName);
    }


    /**
     *  [META_LOOKUP]
     */
    @JsonProperty("metalookups")
    @JSONField(name = "metalookups")
	private List<MetaLookupDTO> lookup ;

}


