package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DAMetricDTO]
 */
@Data
public class DAMetricDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DA_METRICID]
     *
     */
    @JSONField(name = "metric_id")
    @JsonProperty("metric_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String metricId;

    /**
     * 属性 [DA_METRICNAME]
     *
     */
    @JSONField(name = "metric_name")
    @JsonProperty("metric_name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String metricName;

    /**
     * 属性 [METRICTYPE]
     *
     */
    @JSONField(name = "metric_type")
    @JsonProperty("metric_type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String metricType;

    /**
     * 属性 [EXTOP]
     *
     */
    @JSONField(name = "ext_op")
    @JsonProperty("ext_op")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String extOp;

    /**
     * 属性 [REFMETRIC]
     *
     */
    @JSONField(name = "ref_metric")
    @JsonProperty("ref_metric")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String refMetric;

    /**
     * 属性 [BUILDID]
     *
     */
    @JSONField(name = "build_id")
    @JsonProperty("build_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String buildId;

    /**
     * 属性 [BUILDNAME]
     *
     */
    @JSONField(name = "build_name")
    @JsonProperty("build_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String buildName;

    /**
     * 属性 [MODELID]
     *
     */
    @JSONField(name = "model_id")
    @JsonProperty("model_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String modelId;

    /**
     * 属性 [MODELNAME]
     *
     */
    @JSONField(name = "model_name")
    @JsonProperty("model_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String modelName;

    /**
     * 属性 [CFG]
     *
     */
    @JSONField(name = "cfg")
    @JsonProperty("cfg")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String cfg;

    /**
     * 属性 [FIELDSET]
     *
     */
    @JSONField(name = "field_set")
    @JsonProperty("field_set")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String fieldSet;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;


    /**
     * 设置 [DA_METRICNAME]
     */
    public void setMetricName(String  metricName){
        this.metricName = metricName ;
        this.modify("da_metricname",metricName);
    }

    /**
     * 设置 [METRICTYPE]
     */
    public void setMetricType(String  metricType){
        this.metricType = metricType ;
        this.modify("metrictype",metricType);
    }

    /**
     * 设置 [EXTOP]
     */
    public void setExtOp(String  extOp){
        this.extOp = extOp ;
        this.modify("extop",extOp);
    }

    /**
     * 设置 [REFMETRIC]
     */
    public void setRefMetric(String  refMetric){
        this.refMetric = refMetric ;
        this.modify("refmetric",refMetric);
    }

    /**
     * 设置 [BUILDID]
     */
    public void setBuildId(String  buildId){
        this.buildId = buildId ;
        this.modify("buildid",buildId);
    }

    /**
     * 设置 [CFG]
     */
    public void setCfg(String  cfg){
        this.cfg = cfg ;
        this.modify("cfg",cfg);
    }

    /**
     * 设置 [FIELDSET]
     */
    public void setFieldSet(String  fieldSet){
        this.fieldSet = fieldSet ;
        this.modify("fieldset",fieldSet);
    }


}


