package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DAChartDTO]
 */
@Data
public class DAChartDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CHARTID]
     *
     */
    @JSONField(name = "chart_id")
    @JsonProperty("chart_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String chartId;

    /**
     * 属性 [CHARTNAME]
     *
     */
    @JSONField(name = "chart_name")
    @JsonProperty("chart_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String chartName;

    /**
     * 属性 [DICT]
     *
     */
    @JSONField(name = "dict")
    @JsonProperty("dict")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dict;

    /**
     * 属性 [CHARTGROUP]
     *
     */
    @JSONField(name = "group")
    @JsonProperty("group")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String group;

    /**
     * 属性 [VMCFG]
     *
     */
    @JSONField(name = "config")
    @JsonProperty("config")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String config;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;


    /**
     * 设置 [CHARTNAME]
     */
    public void setChartName(String  chartName){
        this.chartName = chartName ;
        this.modify("chartname",chartName);
    }

    /**
     * 设置 [DICT]
     */
    public void setDict(String  dict){
        this.dict = dict ;
        this.modify("dict",dict);
    }

    /**
     * 设置 [CHARTGROUP]
     */
    public void setGroup(String  group){
        this.group = group ;
        this.modify("chartgroup",group);
    }

    /**
     * 设置 [VMCFG]
     */
    public void setConfig(String  config){
        this.config = config ;
        this.modify("vmcfg",config);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }


}


