package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[ExecResultDTO]
 */
@Data
public class ExecResultDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [RU_EXECRESULTID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [RU_EXECRESULTNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 255, message = "内容长度必须小于等于[255]")
    private String name;

    /**
     * 属性 [RULEID]
     *
     */
    @JSONField(name = "rule_id")
    @JsonProperty("rule_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ruleId;

    /**
     * 属性 [RULENAME]
     *
     */
    @JSONField(name = "rule_name")
    @JsonProperty("rule_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ruleName;

    /**
     * 属性 [RETVALUE]
     *
     */
    @JSONField(name = "ret_value")
    @JsonProperty("ret_value")
    private Integer retValue;

    /**
     * 属性 [BUSINESSCAT]
     *
     */
    @JSONField(name = "business_cat")
    @JsonProperty("business_cat")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String businessCat;

    /**
     * 属性 [KEYVALUEFIELD]
     *
     */
    @JSONField(name = "key_value_field")
    @JsonProperty("key_value_field")
    @NotBlank(message = "[标识属性]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String keyValueField;

    /**
     * 属性 [DOMAINSFIELD]
     *
     */
    @JSONField(name = "domains_field")
    @JsonProperty("domains_field")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String domainsField;

    /**
     * 属性 [TIMEFIELD]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "time_field" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("time_field")
    private Timestamp timeField;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [DIMFIELD]
     *
     */
    @JSONField(name = "dim_field")
    @JsonProperty("dim_field")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dimField;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [METRICFIELD]
     *
     */
    @JSONField(name = "metric_field")
    @JsonProperty("metric_field")
    private BigDecimal metricField;

    /**
     * 属性 [EXT1FIELD]
     *
     */
    @JSONField(name = "ext1_field")
    @JsonProperty("ext1_field")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String ext1Field;

    /**
     * 属性 [EXT2FIELD]
     *
     */
    @JSONField(name = "ext2_field")
    @JsonProperty("ext2_field")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String ext2Field;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;


    /**
     * 设置 [RU_EXECRESULTNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("ru_execresultname",name);
    }

    /**
     * 设置 [RULEID]
     */
    public void setRuleId(String  ruleId){
        this.ruleId = ruleId ;
        this.modify("ruleid",ruleId);
    }

    /**
     * 设置 [RULENAME]
     */
    public void setRuleName(String  ruleName){
        this.ruleName = ruleName ;
        this.modify("rulename",ruleName);
    }

    /**
     * 设置 [RETVALUE]
     */
    public void setRetValue(Integer  retValue){
        this.retValue = retValue ;
        this.modify("retvalue",retValue);
    }

    /**
     * 设置 [BUSINESSCAT]
     */
    public void setBusinessCat(String  businessCat){
        this.businessCat = businessCat ;
        this.modify("businesscat",businessCat);
    }

    /**
     * 设置 [KEYVALUEFIELD]
     */
    public void setKeyValueField(String  keyValueField){
        this.keyValueField = keyValueField ;
        this.modify("keyvaluefield",keyValueField);
    }

    /**
     * 设置 [DOMAINSFIELD]
     */
    public void setDomainsField(String  domainsField){
        this.domainsField = domainsField ;
        this.modify("domainsfield",domainsField);
    }

    /**
     * 设置 [TIMEFIELD]
     */
    public void setTimeField(Timestamp  timeField){
        this.timeField = timeField ;
        this.modify("timefield",timeField);
    }

    /**
     * 设置 [DIMFIELD]
     */
    public void setDimField(String  dimField){
        this.dimField = dimField ;
        this.modify("dimfield",dimField);
    }

    /**
     * 设置 [METRICFIELD]
     */
    public void setMetricField(BigDecimal  metricField){
        this.metricField = metricField ;
        this.modify("metricfield",metricField);
    }

    /**
     * 设置 [EXT1FIELD]
     */
    public void setExt1Field(String  ext1Field){
        this.ext1Field = ext1Field ;
        this.modify("ext1field",ext1Field);
    }

    /**
     * 设置 [EXT2FIELD]
     */
    public void setExt2Field(String  ext2Field){
        this.ext2Field = ext2Field ;
        this.modify("ext2field",ext2Field);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }


}


