package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DADimensionDTO]
 */
@Data
public class DADimensionDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DIMID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String id;

    /**
     * 属性 [DIMNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String name;

    /**
     * 属性 [FIELDNAME]
     *
     */
    @JSONField(name = "field")
    @JsonProperty("field")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String field;

    /**
     * 属性 [DICT]
     *
     */
    @JSONField(name = "dict")
    @JsonProperty("dict")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String dict;

    /**
     * 属性 [RECURSIVEFLAG]
     *
     */
    @JSONField(name = "recursive")
    @JsonProperty("recursive")
    private Integer recursive;

    /**
     * 属性 [BUILDID]
     *
     */
    @JSONField(name = "buildid")
    @JsonProperty("buildid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String buildid;

    /**
     * 属性 [MODELID]
     *
     */
    @JSONField(name = "modelid")
    @JsonProperty("modelid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String modelid;


    /**
     * 设置 [DIMNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("dimname",name);
    }

    /**
     * 设置 [FIELDNAME]
     */
    public void setField(String  field){
        this.field = field ;
        this.modify("fieldname",field);
    }

    /**
     * 设置 [DICT]
     */
    public void setDict(String  dict){
        this.dict = dict ;
        this.modify("dict",dict);
    }

    /**
     * 设置 [RECURSIVEFLAG]
     */
    public void setRecursive(Integer  recursive){
        this.recursive = recursive ;
        this.modify("recursiveflag",recursive);
    }

    /**
     * 设置 [BUILDID]
     */
    public void setBuildid(String  buildid){
        this.buildid = buildid ;
        this.modify("buildid",buildid);
    }

    /**
     * 设置 [MODELID]
     */
    public void setModelid(String  modelid){
        this.modelid = modelid ;
        this.modify("modelid",modelid);
    }


}


