package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[DABuildDTO]
 */
@Data
public class DABuildDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [BUILDID]
     *
     */
    @JSONField(name = "build_id")
    @JsonProperty("build_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String buildId;

    /**
     * 属性 [BUILDNAME]
     *
     */
    @JSONField(name = "build_name")
    @JsonProperty("build_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String buildName;

    /**
     * 属性 [LASTRUNTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "last_runtime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("last_runtime")
    private Timestamp lastRuntime;

    /**
     * 属性 [MODELID]
     *
     */
    @JSONField(name = "model_id")
    @JsonProperty("model_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String modelId;

    /**
     * 属性 [MODELNAME]
     *
     */
    @JSONField(name = "model_name")
    @JsonProperty("model_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String modelName;

    /**
     * 属性 [BUILDSTATE]
     *
     */
    @JSONField(name = "state")
    @JsonProperty("state")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String state;

    /**
     * 属性 [TOTAL]
     *
     */
    @JSONField(name = "total")
    @JsonProperty("total")
    private Integer total;

    /**
     * 属性 [PROCESSED]
     *
     */
    @JSONField(name = "processed")
    @JsonProperty("processed")
    private Integer processed;

    /**
     * 属性 [EXTPARAMS]
     *
     */
    @JSONField(name = "ext_params")
    @JsonProperty("ext_params")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String extParams;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String systemId;


    /**
     * 设置 [BUILDNAME]
     */
    public void setBuildName(String  buildName){
        this.buildName = buildName ;
        this.modify("buildname",buildName);
    }

    /**
     * 设置 [LASTRUNTIME]
     */
    public void setLastRuntime(Timestamp  lastRuntime){
        this.lastRuntime = lastRuntime ;
        this.modify("lastruntime",lastRuntime);
    }

    /**
     * 设置 [MODELID]
     */
    public void setModelId(String  modelId){
        this.modelId = modelId ;
        this.modify("modelid",modelId);
    }

    /**
     * 设置 [MODELNAME]
     */
    public void setModelName(String  modelName){
        this.modelName = modelName ;
        this.modify("modelname",modelName);
    }

    /**
     * 设置 [BUILDSTATE]
     */
    public void setState(String  state){
        this.state = state ;
        this.modify("buildstate",state);
    }

    /**
     * 设置 [TOTAL]
     */
    public void setTotal(Integer  total){
        this.total = total ;
        this.modify("total",total);
    }

    /**
     * 设置 [PROCESSED]
     */
    public void setProcessed(Integer  processed){
        this.processed = processed ;
        this.modify("processed",processed);
    }

    /**
     * 设置 [EXTPARAMS]
     */
    public void setExtParams(String  extParams){
        this.extParams = extParams ;
        this.modify("extparams",extParams);
    }


    /**
     *  [DA_DIMENSION]
     */
    @JsonProperty("dadimensions")
    @JSONField(name = "dadimensions")
	private List<DADimensionDTO> dadimension ;

}


