/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ru_execresultname',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'ruleid',
          prop: 'rule_id',
          dataType: 'PICKUP',
        },
        {
          name: 'rulename',
          prop: 'rule_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'retvalue',
          prop: 'ret_value',
          dataType: 'YESNO',
        },
        {
          name: 'dimfield',
          prop: 'dim_field',
          dataType: 'TEXT',
        },
        {
          name: 'domainsfield',
          prop: 'domains_field',
          dataType: 'TEXT',
        },
        {
          name: 'keyvaluefield',
          prop: 'key_value_field',
          dataType: 'TEXT',
        },
        {
          name: 'metricfield',
          prop: 'metric_field',
          dataType: 'DECIMAL',
        },
        {
          name: 'timefield',
          prop: 'time_field',
          dataType: 'DATETIME',
        },
        {
          name: 'businesscat',
          prop: 'business_cat',
          dataType: 'TEXT',
        },
        {
          name: 'ext1field',
          prop: 'ext1_field',
          dataType: 'TEXT',
        },
        {
          name: 'ext2field',
          prop: 'ext2_field',
          dataType: 'TEXT',
        },
        {
          name: 'createdate',
          prop: 'createdate',
          dataType: 'DATETIME',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfkey',
          prop: 'id',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'id',
          dataType: 'GUID',
        },
        {
          name: 'srfmajortext',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'execresult',
          prop: 'id',
        },
      {
        name: 'n_ru_execresultname_like',
        prop: 'n_ru_execresultname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_rulename_like',
        prop: 'n_rulename_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_rulename_eq',
        prop: 'n_rulename_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_ruleid_eq',
        prop: 'n_ruleid_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
        // 预置工作流数据字段
        {
          name: 'srfprocessdefinitionkey',
          prop: 'srfprocessdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskdefinitionkey',
          prop: 'srftaskdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskid',
          prop: 'srftaskid',
          dataType: 'TEXT'
        }
      ]
    }
  }

}