/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'lastruntime',
          prop: 'last_run_time',
          dataType: 'DATETIME',
        },
        {
          name: 'lastendtime',
          prop: 'last_end_time',
          dataType: 'DATETIME',
        },
        {
          name: 'entityid',
          prop: 'entity_id',
          dataType: 'PICKUP',
        },
        {
          name: 'lastread',
          prop: 'last_read',
          dataType: 'BIGINT',
        },
        {
          name: 'srcentityname',
          prop: 'source_entity_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'isenable',
          prop: 'is_enable',
          dataType: 'YESNO',
        },
        {
          name: 'srfmajortext',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'runorder',
          prop: 'run_order',
          dataType: 'INT',
        },
        {
          name: 'srcentityid',
          prop: 'source_entity_id',
          dataType: 'PICKUP',
        },
        {
          name: 'syncgroup',
          prop: 'group',
          dataType: 'TEXT',
        },
        {
          name: 'syncname',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'etltimestamp',
          prop: 'etl_timestamp',
          dataType: 'DATETIME',
        },
        {
          name: 'lastwrite',
          prop: 'last_write',
          dataType: 'BIGINT',
        },
        {
          name: 'entityname',
          prop: 'entity_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'lastrunresult',
          prop: 'last_run_result',
          dataType: 'TEXT',
        },
        {
          name: 'tablesync',
          prop: 'id',
        },
      {
        name: 'n_syncname_like',
        prop: 'n_syncname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_srcentityname_like',
        prop: 'n_srcentityname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_entityname_like',
        prop: 'n_entityname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_lastrunresult_eq',
        prop: 'n_lastrunresult_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_isenable_eq',
        prop: 'n_isenable_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_syncgroup_like',
        prop: 'n_syncgroup_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}