/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'total',
          prop: 'total',
          dataType: 'INT',
        },
        {
          name: 'modelname',
          prop: 'model_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'processed',
          prop: 'processed',
          dataType: 'INT',
        },
        {
          name: 'buildstate',
          prop: 'state',
          dataType: 'TEXT',
        },
        {
          name: 'lastruntime',
          prop: 'last_runtime',
          dataType: 'DATETIME',
        },
        {
          name: 'modelid',
          prop: 'model_id',
          dataType: 'PICKUP',
        },
        {
          name: 'buildname',
          prop: 'build_name',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'build_name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'build_id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'build_id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'dabuild',
          prop: 'build_id',
        },
      {
        name: 'n_buildname_like',
        prop: 'n_buildname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_modelname_like',
        prop: 'n_modelname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}