/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'enginename',
          prop: 'engine_name',
          dataType: 'TEXT',
        },
        {
          name: 'rulegroup',
          prop: 'group',
          dataType: 'SMCODELIST',
        },
        {
          name: 'modelname',
          prop: 'model_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'lastruntime',
          prop: 'last_runtime',
          dataType: 'DATETIME',
        },
        {
          name: 'execstate',
          prop: 'state',
          dataType: 'TEXT',
        },
        {
          name: 'total',
          prop: 'total',
          dataType: 'INT',
        },
        {
          name: 'processed',
          prop: 'processed',
          dataType: 'INT',
        },
        {
          name: 'srfkey',
          prop: 'engine_id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'engine_id',
          dataType: 'TEXT',
        },
        {
          name: 'modelid',
          prop: 'model_id',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'engine_name',
          dataType: 'TEXT',
        },
        {
          name: 'ruleengine',
          prop: 'engine_id',
        },
      {
        name: 'n_enginename_like',
        prop: 'n_enginename_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_modelname_like',
        prop: 'n_modelname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
        // 预置工作流数据字段
        {
          name: 'srfprocessdefinitionkey',
          prop: 'srfprocessdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskdefinitionkey',
          prop: 'srftaskdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskid',
          prop: 'srftaskid',
          dataType: 'TEXT'
        }
      ]
    }
  }

}