/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'expression',
          prop: 'expression',
          dataType: 'LONGTEXT_1000',
          isEditable:true
        },
        {
          name: 'dict',
          prop: 'dict',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'srfmajortext',
          prop: 'field_name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'field_id',
          dataType: 'TEXT',
        },
        {
          name: 'fieldname',
          prop: 'field_name',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'srfkey',
          prop: 'field_id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'reffieldname',
          prop: 'ref_field_name',
          dataType: 'PICKUPTEXT',
          isEditable:true
        },
        {
          name: 'fieldlogicname',
          prop: 'field_logic_name',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'unionkey',
          prop: 'union_key',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'codename',
          prop: 'code_name',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'datalength',
          prop: 'data_length',
          dataType: 'INT',
          isEditable:true
        },
        {
          name: 'showorder',
          prop: 'show_order',
          dataType: 'INT',
          isEditable:true
        },
        {
          name: 'reffieldid',
          prop: 'ref_field_id',
          dataType: 'PICKUP',
          isEditable:true
        },
        {
          name: 'predefined',
          prop: 'predefined',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'extensionfield',
          prop: 'extension_field',
          dataType: 'YESNO',
          isEditable:true
        },
        {
          name: 'fieldtype',
          prop: 'field_type',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'relationname',
          prop: 'relation_name',
          dataType: 'PICKUPTEXT',
          isEditable:true
        },
        {
          name: 'relationid',
          prop: 'relation_id',
          dataType: 'PICKUP',
          isEditable:true
        },
        {
          name: 'entityid',
          prop: 'entity_id',
          dataType: 'PICKUP',
          isEditable:true
        },
        {
          name: 'keyfield',
          prop: 'key_field',
          dataType: 'YESNO',
          isEditable:true
        },
        {
          name: 'nullable',
          prop: 'nullable',
          dataType: 'YESNO',
          isEditable:true
        },
        {
          name: 'physicalfield',
          prop: 'physical_field',
          dataType: 'YESNO',
          isEditable:true
        },
        {
          name: 'entityname',
          prop: 'entity_name',
          dataType: 'PICKUPTEXT',
          isEditable:true
        },
        {
          name: 'majorfield',
          prop: 'major_field',
          dataType: 'YESNO',
          isEditable:true
        },
        {
          name: 'datapreci',
          prop: 'data_preci',
          dataType: 'INT',
          isEditable:true
        },
        {
          name: 'datatype',
          prop: 'data_type',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'metafield',
          prop: 'field_id',
        },
      {
        name: 'n_fieldlogicname_like',
        prop: 'n_fieldlogicname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_fieldname_like',
        prop: 'n_fieldname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_fieldtype_eq',
        prop: 'n_fieldtype_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_datatype_eq',
        prop: 'n_datatype_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_physicalfield_eq',
        prop: 'n_physicalfield_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_entityname_like',
        prop: 'n_entityname_like',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
        // 预置工作流数据字段
        {
          name: 'srfprocessdefinitionkey',
          prop: 'srfprocessdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskdefinitionkey',
          prop: 'srftaskdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskid',
          prop: 'srftaskid',
          dataType: 'TEXT'
        }
      ]
    }
  }

}