package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[RuleItemDTO]
 */
@Data
@ApiModel("规则")
public class RuleItemDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [RULEID]
     *
     */
    @JSONField(name = "rule_id")
    @JsonProperty("rule_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("规则标识")
    private String ruleId;

    /**
     * 属性 [RULENAME]
     *
     */
    @JSONField(name = "rule_name")
    @JsonProperty("rule_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("名称")
    private String ruleName;

    /**
     * 属性 [RULEGROUP]
     *
     */
    @JSONField(name = "group")
    @JsonProperty("group")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("规则分组")
    private String group;

    /**
     * 属性 [BUSINESSCAT]
     *
     */
    @JSONField(name = "business_cat")
    @JsonProperty("business_cat")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("业务类别")
    private String businessCat;

    /**
     * 属性 [MODELID]
     *
     */
    @JSONField(name = "model_id")
    @JsonProperty("model_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("模型标识")
    private String modelId;

    /**
     * 属性 [MODELNAME]
     *
     */
    @JSONField(name = "model_name")
    @JsonProperty("model_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("模型")
    private String modelName;

    /**
     * 属性 [CFG]
     *
     */
    @JSONField(name = "cfg")
    @JsonProperty("cfg")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("配置")
    private String cfg;

    /**
     * 属性 [FIELDSET]
     *
     */
    @JSONField(name = "field_set")
    @JsonProperty("field_set")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("属性集合")
    private String fieldSet;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    @ApiModelProperty("备注")
    private String memo;

    /**
     * 属性 [RULECODE]
     *
     */
    @JSONField(name = "rule_code")
    @JsonProperty("rule_code")
    @NotBlank(message = "[规则码]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("规则码")
    private String ruleCode;

    /**
     * 属性 [CUSTAG]
     *
     */
    @JSONField(name = "cus_tag")
    @JsonProperty("cus_tag")
    @ApiModelProperty("自定义")
    private Integer cusTag;

    /**
     * 属性 [COND]
     *
     */
    @JSONField(name = "cond")
    @JsonProperty("cond")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("条件")
    private String cond;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("系统标识")
    private String systemId;


    /**
     * 设置 [RULENAME]
     */
    public void setRuleName(String  ruleName){
        this.ruleName = ruleName ;
        this.modify("rulename",ruleName);
    }

    /**
     * 设置 [RULEGROUP]
     */
    public void setGroup(String  group){
        this.group = group ;
        this.modify("rulegroup",group);
    }

    /**
     * 设置 [BUSINESSCAT]
     */
    public void setBusinessCat(String  businessCat){
        this.businessCat = businessCat ;
        this.modify("businesscat",businessCat);
    }

    /**
     * 设置 [MODELID]
     */
    public void setModelId(String  modelId){
        this.modelId = modelId ;
        this.modify("modelid",modelId);
    }

    /**
     * 设置 [MODELNAME]
     */
    public void setModelName(String  modelName){
        this.modelName = modelName ;
        this.modify("modelname",modelName);
    }

    /**
     * 设置 [CFG]
     */
    public void setCfg(String  cfg){
        this.cfg = cfg ;
        this.modify("cfg",cfg);
    }

    /**
     * 设置 [FIELDSET]
     */
    public void setFieldSet(String  fieldSet){
        this.fieldSet = fieldSet ;
        this.modify("fieldset",fieldSet);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [RULECODE]
     */
    public void setRuleCode(String  ruleCode){
        this.ruleCode = ruleCode ;
        this.modify("rulecode",ruleCode);
    }

    /**
     * 设置 [CUSTAG]
     */
    public void setCusTag(Integer  cusTag){
        this.cusTag = cusTag ;
        this.modify("custag",cusTag);
    }

    /**
     * 设置 [COND]
     */
    public void setCond(String  cond){
        this.cond = cond ;
        this.modify("cond",cond);
    }


}


