package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[MetaModelDTO]
 */
@Data
@ApiModel("模型")
public class MetaModelDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [MODELID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("标识")
    private String id;

    /**
     * 属性 [MODELNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("名称")
    private String name;

    /**
     * 属性 [CODENAME]
     *
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("代码名称")
    private String codeName;

    /**
     * 属性 [MODELCFG]
     *
     */
    @JSONField(name = "config")
    @JsonProperty("config")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("配置")
    private String config;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("系统标识")
    private String systemId;

    /**
     * 属性 [MATERIALIZEDVIEW]
     *
     */
    @JSONField(name = "materialized_view")
    @JsonProperty("materialized_view")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("物化视图")
    private String materializedView;

    /**
     * 属性 [REFRESHTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "refresh_time" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("refresh_time")
    @ApiModelProperty("刷新时间")
    private Timestamp refreshTime;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("创建时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("最后修改时间")
    private Timestamp updatedate;


    /**
     * 设置 [MODELNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("modelname",name);
    }

    /**
     * 设置 [CODENAME]
     */
    public void setCodeName(String  codeName){
        this.codeName = codeName ;
        this.modify("codename",codeName);
    }

    /**
     * 设置 [MODELCFG]
     */
    public void setConfig(String  config){
        this.config = config ;
        this.modify("modelcfg",config);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }

    /**
     * 设置 [MATERIALIZEDVIEW]
     */
    public void setMaterializedView(String  materializedView){
        this.materializedView = materializedView ;
        this.modify("materializedview",materializedView);
    }

    /**
     * 设置 [REFRESHTIME]
     */
    public void setRefreshTime(Timestamp  refreshTime){
        this.refreshTime = refreshTime ;
        this.modify("refreshtime",refreshTime);
    }


}


