package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.rule.domain.ExecResult;
import cn.ibizlab.core.rule.service.IExecResultService;
import cn.ibizlab.core.rule.filter.ExecResultSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"执行结果" })
@RestController("api-execresult")
@RequestMapping("")
public class ExecResultResource {

    @Autowired
    public IExecResultService execresultService;

    @Autowired
    @Lazy
    public ExecResultMapping execresultMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Create-all')")
    @ApiOperation(value = "新建执行结果", tags = {"执行结果" },  notes = "新建执行结果")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults")
    public ResponseEntity<ExecResultDTO> create(@Validated @RequestBody ExecResultDTO execresultdto) {
        ExecResult domain = execresultMapping.toDomain(execresultdto);
		execresultService.create(domain);
        ExecResultDTO dto = execresultMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Create-all')")
    @ApiOperation(value = "批量新建执行结果", tags = {"执行结果" },  notes = "批量新建执行结果")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<ExecResultDTO> execresultdtos) {
        execresultService.createBatch(execresultMapping.toDomain(execresultdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "execresult" , versionfield = "updatedate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Update-all')")
    @ApiOperation(value = "更新执行结果", tags = {"执行结果" },  notes = "更新执行结果")
	@RequestMapping(method = RequestMethod.PUT, value = "/execresults/{execresult_id}")
    public ResponseEntity<ExecResultDTO> update(@PathVariable("execresult_id") String execresult_id, @RequestBody ExecResultDTO execresultdto) {
		ExecResult domain  = execresultMapping.toDomain(execresultdto);
        domain .setId(execresult_id);
		execresultService.update(domain );
		ExecResultDTO dto = execresultMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Update-all')")
    @ApiOperation(value = "批量更新执行结果", tags = {"执行结果" },  notes = "批量更新执行结果")
	@RequestMapping(method = RequestMethod.PUT, value = "/execresults/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<ExecResultDTO> execresultdtos) {
        execresultService.updateBatch(execresultMapping.toDomain(execresultdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Remove-all')")
    @ApiOperation(value = "删除执行结果", tags = {"执行结果" },  notes = "删除执行结果")
	@RequestMapping(method = RequestMethod.DELETE, value = "/execresults/{execresult_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("execresult_id") String execresult_id) {
         return ResponseEntity.status(HttpStatus.OK).body(execresultService.remove(execresult_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Remove-all')")
    @ApiOperation(value = "批量删除执行结果", tags = {"执行结果" },  notes = "批量删除执行结果")
	@RequestMapping(method = RequestMethod.DELETE, value = "/execresults/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        execresultService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Get-all')")
    @ApiOperation(value = "获取执行结果", tags = {"执行结果" },  notes = "获取执行结果")
	@RequestMapping(method = RequestMethod.GET, value = "/execresults/{execresult_id}")
    public ResponseEntity<ExecResultDTO> get(@PathVariable("execresult_id") String execresult_id) {
        ExecResult domain = execresultService.get(execresult_id);
        ExecResultDTO dto = execresultMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取执行结果草稿", tags = {"执行结果" },  notes = "获取执行结果草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/execresults/getdraft")
    public ResponseEntity<ExecResultDTO> getDraft(ExecResultDTO dto) {
        ExecResult domain = execresultMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(execresultMapping.toDto(execresultService.getDraft(domain)));
    }

    @ApiOperation(value = "检查执行结果", tags = {"执行结果" },  notes = "检查执行结果")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody ExecResultDTO execresultdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(execresultService.checkKey(execresultMapping.toDomain(execresultdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-DeleteAsync-all')")
    @ApiOperation(value = "DeleteAsync", tags = {"执行结果" },  notes = "DeleteAsync")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/{execresult_id}/deleteasync")
    public ResponseEntity<ExecResultDTO> deleteAsync(@PathVariable("execresult_id") String execresult_id, @RequestBody ExecResultDTO execresultdto) {
        ExecResult domain = execresultMapping.toDomain(execresultdto);
        domain.setId(execresult_id);
        domain = execresultService.deleteAsync(domain);
        execresultdto = execresultMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(execresultdto);
    }
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-DeleteAsync-all')")
    @ApiOperation(value = "批量处理[DeleteAsync]", tags = {"执行结果" },  notes = "批量处理[DeleteAsync]")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/deleteasyncbatch")
    public ResponseEntity<Boolean> deleteAsyncBatch(@RequestBody List<ExecResultDTO> execresultdtos) {
        List<ExecResult> domains = execresultMapping.toDomain(execresultdtos);
        boolean result = execresultService.deleteAsyncBatch(domains);
        return ResponseEntity.status(HttpStatus.OK).body(result);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Save-all')")
    @ApiOperation(value = "保存执行结果", tags = {"执行结果" },  notes = "保存执行结果")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/save")
    public ResponseEntity<ExecResultDTO> save(@RequestBody ExecResultDTO execresultdto) {
        ExecResult domain = execresultMapping.toDomain(execresultdto);
        execresultService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(execresultMapping.toDto(domain));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-Save-all')")
    @ApiOperation(value = "批量保存执行结果", tags = {"执行结果" },  notes = "批量保存执行结果")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<ExecResultDTO> execresultdtos) {
        execresultService.saveBatch(execresultMapping.toDomain(execresultdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-SaveAsync-all')")
    @ApiOperation(value = "SaveAsync", tags = {"执行结果" },  notes = "SaveAsync")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/{execresult_id}/saveasync")
    public ResponseEntity<ExecResultDTO> saveAsync(@PathVariable("execresult_id") String execresult_id, @RequestBody ExecResultDTO execresultdto) {
        ExecResult domain = execresultMapping.toDomain(execresultdto);
        domain.setId(execresult_id);
        domain = execresultService.saveAsync(domain);
        execresultdto = execresultMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(execresultdto);
    }
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-SaveAsync-all')")
    @ApiOperation(value = "批量处理[SaveAsync]", tags = {"执行结果" },  notes = "批量处理[SaveAsync]")
	@RequestMapping(method = RequestMethod.POST, value = "/execresults/saveasyncbatch")
    public ResponseEntity<Boolean> saveAsyncBatch(@RequestBody List<ExecResultDTO> execresultdtos) {
        List<ExecResult> domains = execresultMapping.toDomain(execresultdtos);
        boolean result = execresultService.saveAsyncBatch(domains);
        return ResponseEntity.status(HttpStatus.OK).body(result);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-searchDefault-all')")
	@ApiOperation(value = "获取数据集", tags = {"执行结果" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/execresults/fetchdefault")
	public ResponseEntity<List<ExecResultDTO>> fetchDefault(ExecResultSearchContext context) {
        Page<ExecResult> domains = execresultService.searchDefault(context) ;
        List<ExecResultDTO> list = execresultMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzdst-ExecResult-searchDefault-all')")
	@ApiOperation(value = "查询数据集", tags = {"执行结果" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/execresults/searchdefault")
	public ResponseEntity<Page<ExecResultDTO>> searchDefault(@RequestBody ExecResultSearchContext context) {
        Page<ExecResult> domains = execresultService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(execresultMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

