package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[TableSyncDTO]
 */
@Data
@ApiModel("ETL表同步")
public class TableSyncDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [SYNCID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("标识")
    private String id;

    /**
     * 属性 [SYNCNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("标题")
    private String name;

    /**
     * 属性 [SRCENTITYID]
     *
     */
    @JSONField(name = "source_entity_id")
    @JsonProperty("source_entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("源实体标识")
    private String sourceEntityId;

    /**
     * 属性 [SRCENTITYNAME]
     *
     */
    @JSONField(name = "source_entity_name")
    @JsonProperty("source_entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("源实体名称")
    private String sourceEntityName;

    /**
     * 属性 [SRCDSID]
     *
     */
    @JSONField(name = "source_ds_id")
    @JsonProperty("source_ds_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("源实体数据源")
    private String sourceDsId;

    /**
     * 属性 [SRCSYSTEMID]
     *
     */
    @JSONField(name = "source_system_id")
    @JsonProperty("source_system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("源实体系统标识")
    private String sourceSystemId;

    /**
     * 属性 [SRCEXP]
     *
     */
    @JSONField(name = "source_expression")
    @JsonProperty("source_expression")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("源数据表达式")
    private String sourceExpression;

    /**
     * 属性 [ENTITYID]
     *
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("目标实体标识")
    private String entityId;

    /**
     * 属性 [ENTITYNAME]
     *
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("目标实体")
    private String entityName;

    /**
     * 属性 [DSID]
     *
     */
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("目标数据源")
    private String dsId;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("系统标识")
    private String systemId;

    /**
     * 属性 [MAPPINGCFG]
     *
     */
    @JSONField(name = "mapping_config")
    @JsonProperty("mapping_config")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("映射配置")
    private String mappingConfig;

    /**
     * 属性 [SYNCGROUP]
     *
     */
    @JSONField(name = "group")
    @JsonProperty("group")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("分组")
    private String group;

    /**
     * 属性 [RUNORDER]
     *
     */
    @JSONField(name = "run_order")
    @JsonProperty("run_order")
    @ApiModelProperty("排序")
    private Integer runOrder;

    /**
     * 属性 [RUNCRON]
     *
     */
    @JSONField(name = "run_cron")
    @JsonProperty("run_cron")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("定时器cron")
    private String runCron;

    /**
     * 属性 [ETLTIMESTAMP]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "etl_timestamp" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("etl_timestamp")
    @ApiModelProperty("时间戳")
    private Timestamp etlTimestamp;

    /**
     * 属性 [LASTRUNTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "last_run_time" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("last_run_time")
    @ApiModelProperty("上次运行开始时间")
    private Timestamp lastRunTime;

    /**
     * 属性 [LASTENDTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "last_end_time" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("last_end_time")
    @ApiModelProperty("上次运行结束时间")
    private Timestamp lastEndTime;

    /**
     * 属性 [LASTRUNRESULT]
     *
     */
    @JSONField(name = "last_run_result")
    @JsonProperty("last_run_result")
    @Size(min = 0, max = 20, message = "内容长度必须小于等于[20]")
    @ApiModelProperty("上次运行结果")
    private String lastRunResult;

    /**
     * 属性 [LASTREAD]
     *
     */
    @JSONField(name = "last_read")
    @JsonProperty("last_read")
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("上次运行读取行")
    private Long lastRead;

    /**
     * 属性 [LASTWRITE]
     *
     */
    @JSONField(name = "last_write")
    @JsonProperty("last_write")
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("上次运行写入行")
    private Long lastWrite;

    /**
     * 属性 [ISENABLE]
     *
     */
    @JSONField(name = "is_enable")
    @JsonProperty("is_enable")
    @ApiModelProperty("是否启用")
    private Integer isEnable;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("最后修改时间")
    private Timestamp updatedate;


    /**
     * 设置 [SYNCNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("syncname",name);
    }

    /**
     * 设置 [SRCENTITYID]
     */
    public void setSourceEntityId(String  sourceEntityId){
        this.sourceEntityId = sourceEntityId ;
        this.modify("srcentityid",sourceEntityId);
    }

    /**
     * 设置 [SRCENTITYNAME]
     */
    public void setSourceEntityName(String  sourceEntityName){
        this.sourceEntityName = sourceEntityName ;
        this.modify("srcentityname",sourceEntityName);
    }

    /**
     * 设置 [SRCDSID]
     */
    public void setSourceDsId(String  sourceDsId){
        this.sourceDsId = sourceDsId ;
        this.modify("srcdsid",sourceDsId);
    }

    /**
     * 设置 [SRCSYSTEMID]
     */
    public void setSourceSystemId(String  sourceSystemId){
        this.sourceSystemId = sourceSystemId ;
        this.modify("srcsystemid",sourceSystemId);
    }

    /**
     * 设置 [SRCEXP]
     */
    public void setSourceExpression(String  sourceExpression){
        this.sourceExpression = sourceExpression ;
        this.modify("srcexp",sourceExpression);
    }

    /**
     * 设置 [ENTITYID]
     */
    public void setEntityId(String  entityId){
        this.entityId = entityId ;
        this.modify("entityid",entityId);
    }

    /**
     * 设置 [ENTITYNAME]
     */
    public void setEntityName(String  entityName){
        this.entityName = entityName ;
        this.modify("entityname",entityName);
    }

    /**
     * 设置 [DSID]
     */
    public void setDsId(String  dsId){
        this.dsId = dsId ;
        this.modify("dsid",dsId);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }

    /**
     * 设置 [MAPPINGCFG]
     */
    public void setMappingConfig(String  mappingConfig){
        this.mappingConfig = mappingConfig ;
        this.modify("mappingcfg",mappingConfig);
    }

    /**
     * 设置 [SYNCGROUP]
     */
    public void setGroup(String  group){
        this.group = group ;
        this.modify("syncgroup",group);
    }

    /**
     * 设置 [RUNORDER]
     */
    public void setRunOrder(Integer  runOrder){
        this.runOrder = runOrder ;
        this.modify("runorder",runOrder);
    }

    /**
     * 设置 [RUNCRON]
     */
    public void setRunCron(String  runCron){
        this.runCron = runCron ;
        this.modify("runcron",runCron);
    }

    /**
     * 设置 [ETLTIMESTAMP]
     */
    public void setEtlTimestamp(Timestamp  etlTimestamp){
        this.etlTimestamp = etlTimestamp ;
        this.modify("etltimestamp",etlTimestamp);
    }

    /**
     * 设置 [LASTRUNTIME]
     */
    public void setLastRunTime(Timestamp  lastRunTime){
        this.lastRunTime = lastRunTime ;
        this.modify("lastruntime",lastRunTime);
    }

    /**
     * 设置 [LASTENDTIME]
     */
    public void setLastEndTime(Timestamp  lastEndTime){
        this.lastEndTime = lastEndTime ;
        this.modify("lastendtime",lastEndTime);
    }

    /**
     * 设置 [LASTRUNRESULT]
     */
    public void setLastRunResult(String  lastRunResult){
        this.lastRunResult = lastRunResult ;
        this.modify("lastrunresult",lastRunResult);
    }

    /**
     * 设置 [LASTREAD]
     */
    public void setLastRead(Long  lastRead){
        this.lastRead = lastRead ;
        this.modify("lastread",lastRead);
    }

    /**
     * 设置 [LASTWRITE]
     */
    public void setLastWrite(Long  lastWrite){
        this.lastWrite = lastWrite ;
        this.modify("lastwrite",lastWrite);
    }

    /**
     * 设置 [ISENABLE]
     */
    public void setIsEnable(Integer  isEnable){
        this.isEnable = isEnable ;
        this.modify("isenable",isEnable);
    }


}


