package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[MetaFieldDTO]
 */
@Data
@ApiModel("属性")
public class MetaFieldDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [FIELDID]
     *
     */
    @JSONField(name = "field_id")
    @JsonProperty("field_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("属性标识")
    private String fieldId;

    /**
     * 属性 [FIELDNAME]
     *
     */
    @JSONField(name = "field_name")
    @JsonProperty("field_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("属性名称")
    private String fieldName;

    /**
     * 属性 [CODENAME]
     *
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("代码名称")
    private String codeName;

    /**
     * 属性 [ENTITYID]
     *
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("实体标识")
    private String entityId;

    /**
     * 属性 [ENTITYNAME]
     *
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("实体名称")
    private String entityName;

    /**
     * 属性 [ENTITYCODENAME]
     *
     */
    @JSONField(name = "entity_code_name")
    @JsonProperty("entity_code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("实体代码名称")
    private String entityCodeName;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("系统")
    private String systemId;

    /**
     * 属性 [FIELDLOGICNAME]
     *
     */
    @JSONField(name = "field_logic_name")
    @JsonProperty("field_logic_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("属性逻辑名")
    private String fieldLogicName;

    /**
     * 属性 [FIELDUNINAME]
     *
     */
    @JSONField(name = "field_uni_name")
    @JsonProperty("field_uni_name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("属性全路径名称")
    private String fieldUniName;

    /**
     * 属性 [FIELDSHOWNAME]
     *
     */
    @JSONField(name = "field_show_name")
    @JsonProperty("field_show_name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("显示名称")
    private String fieldShowName;

    /**
     * 属性 [REFFIELDID]
     *
     */
    @JSONField(name = "ref_field_id")
    @JsonProperty("ref_field_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("引用属性标识")
    private String refFieldId;

    /**
     * 属性 [REFFIELDNAME]
     *
     */
    @JSONField(name = "ref_field_name")
    @JsonProperty("ref_field_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("引用属性名称")
    private String refFieldName;

    /**
     * 属性 [RELATIONID]
     *
     */
    @JSONField(name = "relation_id")
    @JsonProperty("relation_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("引用关系标识")
    private String relationId;

    /**
     * 属性 [RELATIONNAME]
     *
     */
    @JSONField(name = "relation_name")
    @JsonProperty("relation_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("引用关系")
    private String relationName;

    /**
     * 属性 [RELATIONCODENAME]
     *
     */
    @JSONField(name = "relation_code_name")
    @JsonProperty("relation_code_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("关系代码")
    private String relationCodeName;

    /**
     * 属性 [REFENTITYNAME]
     *
     */
    @JSONField(name = "ref_entity_name")
    @JsonProperty("ref_entity_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("引用实体")
    private String refEntityName;

    /**
     * 属性 [KEYFIELD]
     *
     */
    @JSONField(name = "key_field")
    @JsonProperty("key_field")
    @ApiModelProperty("主键")
    private Integer keyField;

    /**
     * 属性 [MAJORFIELD]
     *
     */
    @JSONField(name = "major_field")
    @JsonProperty("major_field")
    @ApiModelProperty("主信息")
    private Integer majorField;

    /**
     * 属性 [UNIONKEY]
     *
     */
    @JSONField(name = "union_key")
    @JsonProperty("union_key")
    @Size(min = 0, max = 70, message = "内容长度必须小于等于[70]")
    @ApiModelProperty("联合主键")
    private String unionKey;

    /**
     * 属性 [FIELDTYPE]
     *
     */
    @JSONField(name = "field_type")
    @JsonProperty("field_type")
    @Size(min = 0, max = 70, message = "内容长度必须小于等于[70]")
    @ApiModelProperty("属性类型")
    private String fieldType;

    /**
     * 属性 [PREDEFINED]
     *
     */
    @JSONField(name = "predefined")
    @JsonProperty("predefined")
    @Size(min = 0, max = 70, message = "内容长度必须小于等于[70]")
    @ApiModelProperty("预定义类型")
    private String predefined;

    /**
     * 属性 [DICT]
     *
     */
    @JSONField(name = "dict")
    @JsonProperty("dict")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("数据字典")
    private String dict;

    /**
     * 属性 [NULLABLE]
     *
     */
    @JSONField(name = "nullable")
    @JsonProperty("nullable")
    @ApiModelProperty("允许为空")
    private Integer nullable;

    /**
     * 属性 [PHYSICALFIELD]
     *
     */
    @JSONField(name = "physical_field")
    @JsonProperty("physical_field")
    @ApiModelProperty("物理属性")
    private Integer physicalField;

    /**
     * 属性 [DATATYPE]
     *
     */
    @JSONField(name = "data_type")
    @JsonProperty("data_type")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("数据类型")
    private String dataType;

    /**
     * 属性 [DATALENGTH]
     *
     */
    @JSONField(name = "data_length")
    @JsonProperty("data_length")
    @ApiModelProperty("长度")
    private Integer dataLength;

    /**
     * 属性 [DATAPRECI]
     *
     */
    @JSONField(name = "data_preci")
    @JsonProperty("data_preci")
    @ApiModelProperty("精度")
    private Integer dataPreci;

    /**
     * 属性 [EXPRESSION]
     *
     */
    @JSONField(name = "expression")
    @JsonProperty("expression")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    @ApiModelProperty("逻辑表达式")
    private String expression;

    /**
     * 属性 [EXTENSIONFIELD]
     *
     */
    @JSONField(name = "extension_field")
    @JsonProperty("extension_field")
    @ApiModelProperty("扩展属性")
    private Integer extensionField;

    /**
     * 属性 [ISENABLEAUDIT]
     *
     */
    @JSONField(name = "is_enable_audit")
    @JsonProperty("is_enable_audit")
    @ApiModelProperty("审计")
    private Integer isEnableAudit;

    /**
     * 属性 [SHOWORDER]
     *
     */
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    @ApiModelProperty("排序")
    private Integer showOrder;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("创建时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("最后修改时间")
    private Timestamp updatedate;


    /**
     * 设置 [FIELDNAME]
     */
    public void setFieldName(String  fieldName){
        this.fieldName = fieldName ;
        this.modify("fieldname",fieldName);
    }

    /**
     * 设置 [CODENAME]
     */
    public void setCodeName(String  codeName){
        this.codeName = codeName ;
        this.modify("codename",codeName);
    }

    /**
     * 设置 [ENTITYID]
     */
    public void setEntityId(String  entityId){
        this.entityId = entityId ;
        this.modify("entityid",entityId);
    }

    /**
     * 设置 [ENTITYNAME]
     */
    public void setEntityName(String  entityName){
        this.entityName = entityName ;
        this.modify("entityname",entityName);
    }

    /**
     * 设置 [FIELDLOGICNAME]
     */
    public void setFieldLogicName(String  fieldLogicName){
        this.fieldLogicName = fieldLogicName ;
        this.modify("fieldlogicname",fieldLogicName);
    }

    /**
     * 设置 [REFFIELDID]
     */
    public void setRefFieldId(String  refFieldId){
        this.refFieldId = refFieldId ;
        this.modify("reffieldid",refFieldId);
    }

    /**
     * 设置 [REFFIELDNAME]
     */
    public void setRefFieldName(String  refFieldName){
        this.refFieldName = refFieldName ;
        this.modify("reffieldname",refFieldName);
    }

    /**
     * 设置 [RELATIONID]
     */
    public void setRelationId(String  relationId){
        this.relationId = relationId ;
        this.modify("relationid",relationId);
    }

    /**
     * 设置 [RELATIONNAME]
     */
    public void setRelationName(String  relationName){
        this.relationName = relationName ;
        this.modify("relationname",relationName);
    }

    /**
     * 设置 [KEYFIELD]
     */
    public void setKeyField(Integer  keyField){
        this.keyField = keyField ;
        this.modify("keyfield",keyField);
    }

    /**
     * 设置 [MAJORFIELD]
     */
    public void setMajorField(Integer  majorField){
        this.majorField = majorField ;
        this.modify("majorfield",majorField);
    }

    /**
     * 设置 [UNIONKEY]
     */
    public void setUnionKey(String  unionKey){
        this.unionKey = unionKey ;
        this.modify("unionkey",unionKey);
    }

    /**
     * 设置 [FIELDTYPE]
     */
    public void setFieldType(String  fieldType){
        this.fieldType = fieldType ;
        this.modify("fieldtype",fieldType);
    }

    /**
     * 设置 [PREDEFINED]
     */
    public void setPredefined(String  predefined){
        this.predefined = predefined ;
        this.modify("predefined",predefined);
    }

    /**
     * 设置 [DICT]
     */
    public void setDict(String  dict){
        this.dict = dict ;
        this.modify("dict",dict);
    }

    /**
     * 设置 [NULLABLE]
     */
    public void setNullable(Integer  nullable){
        this.nullable = nullable ;
        this.modify("nullable",nullable);
    }

    /**
     * 设置 [PHYSICALFIELD]
     */
    public void setPhysicalField(Integer  physicalField){
        this.physicalField = physicalField ;
        this.modify("physicalfield",physicalField);
    }

    /**
     * 设置 [DATATYPE]
     */
    public void setDataType(String  dataType){
        this.dataType = dataType ;
        this.modify("datatype",dataType);
    }

    /**
     * 设置 [DATALENGTH]
     */
    public void setDataLength(Integer  dataLength){
        this.dataLength = dataLength ;
        this.modify("datalength",dataLength);
    }

    /**
     * 设置 [DATAPRECI]
     */
    public void setDataPreci(Integer  dataPreci){
        this.dataPreci = dataPreci ;
        this.modify("datapreci",dataPreci);
    }

    /**
     * 设置 [EXPRESSION]
     */
    public void setExpression(String  expression){
        this.expression = expression ;
        this.modify("expression",expression);
    }

    /**
     * 设置 [EXTENSIONFIELD]
     */
    public void setExtensionField(Integer  extensionField){
        this.extensionField = extensionField ;
        this.modify("extensionfield",extensionField);
    }

    /**
     * 设置 [ISENABLEAUDIT]
     */
    public void setIsEnableAudit(Integer  isEnableAudit){
        this.isEnableAudit = isEnableAudit ;
        this.modify("isenableaudit",isEnableAudit);
    }

    /**
     * 设置 [SHOWORDER]
     */
    public void setShowOrder(Integer  showOrder){
        this.showOrder = showOrder ;
        this.modify("showorder",showOrder);
    }


}


