package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[ExecLogDTO]
 */
@Data
@ApiModel("执行日志")
public class ExecLogDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [RU_EXECLOGID]
     *
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("规则执行日志标识")
    private String id;

    /**
     * 属性 [RU_EXECLOGNAME]
     *
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("规则执行批次")
    private String name;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [RETCODE]
     *
     */
    @JSONField(name = "ret_code")
    @JsonProperty("ret_code")
    @ApiModelProperty("执行结果")
    private Integer retCode;

    /**
     * 属性 [CNT]
     *
     */
    @JSONField(name = "cnt")
    @JsonProperty("cnt")
    @ApiModelProperty("总行数")
    private Integer cnt;

    /**
     * 属性 [SUCC]
     *
     */
    @JSONField(name = "succ")
    @JsonProperty("succ")
    @ApiModelProperty("成功行数")
    private Integer succ;

    /**
     * 属性 [KEYVALUEFIELD]
     *
     */
    @JSONField(name = "key_value_field")
    @JsonProperty("key_value_field")
    @NotBlank(message = "[标识属性]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("标识属性")
    private String keyValueField;

    /**
     * 属性 [RUNBODY]
     *
     */
    @JSONField(name = "run_body")
    @JsonProperty("run_body")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("运行内容")
    private String runBody;

    /**
     * 属性 [RUNRESULT]
     *
     */
    @JSONField(name = "run_result")
    @JsonProperty("run_result")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("运行结果")
    private String runResult;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("系统标识")
    private String systemId;


    /**
     * 设置 [RU_EXECLOGNAME]
     */
    public void setName(String  name){
        this.name = name ;
        this.modify("ru_execlogname",name);
    }

    /**
     * 设置 [RETCODE]
     */
    public void setRetCode(Integer  retCode){
        this.retCode = retCode ;
        this.modify("retcode",retCode);
    }

    /**
     * 设置 [CNT]
     */
    public void setCnt(Integer  cnt){
        this.cnt = cnt ;
        this.modify("cnt",cnt);
    }

    /**
     * 设置 [SUCC]
     */
    public void setSucc(Integer  succ){
        this.succ = succ ;
        this.modify("succ",succ);
    }

    /**
     * 设置 [KEYVALUEFIELD]
     */
    public void setKeyValueField(String  keyValueField){
        this.keyValueField = keyValueField ;
        this.modify("keyvaluefield",keyValueField);
    }

    /**
     * 设置 [RUNBODY]
     */
    public void setRunBody(String  runBody){
        this.runBody = runBody ;
        this.modify("runbody",runBody);
    }

    /**
     * 设置 [RUNRESULT]
     */
    public void setRunResult(String  runResult){
        this.runResult = runResult ;
        this.modify("runresult",runResult);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }


}


