package cn.ibizlab.api.rest.extensions;

import cn.ibizlab.core.dict.extensions.service.DictDstService;
import cn.ibizlab.core.lite.domain.DstSystem;
import cn.ibizlab.core.lite.domain.MetaField;
import cn.ibizlab.core.lite.extensions.domain.*;
import cn.ibizlab.core.lite.extensions.model.DataModel;
import cn.ibizlab.core.lite.extensions.model.Property;
import cn.ibizlab.core.lite.extensions.service.LiteDataService;
import cn.ibizlab.core.lite.extensions.service.LiteModelService;
import cn.ibizlab.util.dict.CodeItem;
import cn.ibizlab.util.dict.CodeList;
import cn.ibizlab.util.dict.Option;
import cn.ibizlab.util.filter.QueryFilter;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Api(tags = {"接口" })
@RestController("api-litecore")
@RequestMapping("")
public class DstCoreResource {

    @Autowired
    private LiteModelService liteModelService;

    @Autowired
    private LiteDataService liteDataService;


    @RequestMapping(method = RequestMethod.GET, value = "/dst/datamodels/{modelid}/data/{key}")
    public ResponseEntity<ModelObj> getModelObj(@PathVariable(name="modelid",required = false) String modelid,@PathVariable(name="key",required = false) String key)
    {

        if(StringUtils.isEmpty(modelid))
            modelid="dataModelff8080816a8b510c016a8c2f18b10001";
        return ResponseEntity.ok(liteDataService.getModelObjs(modelid, null,key));
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}","/dst/datamodels/{modelid}/name/{modelname}"})
    public ResponseEntity<DataModel> getDataModel(@PathVariable(name="modelid",required = false) String modelid,
                                                  @PathVariable(name="modelname",required = false) String modelname)
    {
        return ResponseEntity.ok(liteModelService.getDataModel(modelid,modelname));
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}/submodels","/dst/datamodels/{modelid}/name/{modelname}/submodels"})
    public ResponseEntity<List<Option>> getDataModelSubModels(@PathVariable(name="modelid",required = false) String modelid,
                                                              @PathVariable(name="modelname",required = false) String modelname)
    {
        List<Option> list =  new ArrayList<>();
        liteModelService.getDataModel(modelid,modelname).getSubDataModel().forEach(dataModel -> list.add(new Option().setId(dataModel.getDataModelName()).setLabel(dataModel.getFactPorperty().getEntityModel().getLogicName()+"["+dataModel.getDataModelName()+"]")));
        return ResponseEntity.ok(list);
    }

    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}/propertys","/dst/datamodels/{modelid}/name/{modelname}/propertys"})
    public ResponseEntity<List<Option>> getDataModelParentProperty(@PathVariable(name="modelid",required = false) String modelid,
                                                              @PathVariable(name="modelname",required = false) String modelname)
    {
        List<Option> list =  new ArrayList<>();
        liteModelService.getDataModel(modelid,modelname).getParentProperty().forEach(property -> {
            Option option = new Option().setId(property.getPropertyName()).setLabel(property.getEntityModel().getLogicName()+"["+property.getPropertyName()+"]");
            list.add(option);
        });
        return ResponseEntity.ok(list);
    }



    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}/propertys/{propertyname}/fields","/dst/datamodels/{modelid}/name/{modelname}/propertys/{propertyname}/fields"})
    public ResponseEntity<List<Option>> getDataModelParentField(@PathVariable(name="modelid",required = false) String modelid,
                                                                   @PathVariable(name="modelname",required = false) String modelname,
                                                                @PathVariable(name="propertyname",required = false) String propertyname)
    {
        List<Option> list =  new ArrayList<>();
        Property property=liteModelService.getDataModel(modelid,modelname).findObjectProperty(propertyname,"UP");
        property.getEntityModel().getFields().forEach(field -> {
            Option option = new Option().setId(property.getPropertyName()+"."+field.getColumnName()).setLabel(field.getComment()+"["+field.getColumnName()+"]");
            list.add(option);
        });
        return ResponseEntity.ok(list);
    }


    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}/allpropertys"})
    public ResponseEntity<List<Option>> getDataModelParentProperty(@PathVariable(name="modelid",required = false) String modelid)
    {
        List<Option> list =  new ArrayList<>();
        liteModelService.getDataModel(modelid).getAllProperty().forEach(property -> {
            Option option = new Option().setId(property.getPropertyName()).setLabel(property.getEntityModel().getLogicName()+"["+property.getPropertyName()+"]");
            list.add(option);
        });
        return ResponseEntity.ok(list);
    }
    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}/allpropertys/{propertyname}/fields"})
    public ResponseEntity<List<Option>> getDataModelField(@PathVariable(name="modelid",required = false) String modelid,
                                                                @PathVariable(name="propertyname",required = false) String propertyname,
                                                                @PathVariable(name="fieldname",required = false) String fieldname)
    {
        List<Option> list =  new ArrayList<>();
        Property property=liteModelService.getDataModel(modelid).findObjectProperty(propertyname,"ALL");
        property.getEntityModel().getFields().forEach(field -> {
            Option option = new Option().setId(property.getPropertyName()+"."+field.getColumnName()).setLabel(field.getComment()+"["+field.getColumnName()+"]");
            list.add(option);
        });
        return ResponseEntity.ok(list);
    }

    @Autowired
    private DictDstService dictDstService;

    @RequestMapping(method = RequestMethod.GET, value = {"/dst/datamodels/{modelid}/{propertyname}.{fieldname}/dict"})
    public ResponseEntity<List<CodeItem>> getDataModelFieldDict(@PathVariable(name="modelid",required = false) String modelid,
                                                                @PathVariable(name="propertyname",required = false) String propertyname,
                                                                @PathVariable(name="fieldname",required = false) String fieldname)
    {
        List<CodeItem> list =  new ArrayList<>();
        Property property=liteModelService.getDataModel(modelid).findObjectProperty(propertyname,"ALL");
        if(property!=null)
        {
            MetaField field=property.getEntityModel().getField(fieldname).getField();
            if(field!=null)
            {
                String dict = field.getDict();
                if(!StringUtils.isEmpty(dict))
                {
                    CodeList codeList= dictDstService.getCodeListCatalog(dict);
                    if(codeList!=null)
                        list=codeList.getOptions();

                }
            }

        }

        return ResponseEntity.ok(list);
    }

    @RequestMapping(method = RequestMethod.GET, value = "/dst/{system}/entitys")
    public ResponseEntity<List<EntityModel>> getEntityModel(@PathVariable("system") String system) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system));
    }

    @RequestMapping(method = RequestMethod.GET, value = "/dst/{system}/entitys/{entity}")
    public ResponseEntity<EntityModel> getEntityModel(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity));
    }

    @RequestMapping(method = RequestMethod.GET, value = "/dst/{system}/entitys/{entity}/fields")
    public ResponseEntity<List<FieldModel>> getEntityModelFields(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity).getFields());
    }

    @RequestMapping(method = RequestMethod.GET, value = "/dst/{system}/entitys/{entity}/references")
    public ResponseEntity<List<RelationshipModel>> getEntityModelReferences(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity).getReferences());
    }

    @RequestMapping(method = RequestMethod.GET, value = "/dst/{system}/entitys/{entity}/nesteds")
    public ResponseEntity<List<RelationshipModel>> getEntityModelNesteds(@PathVariable("system") String system, @PathVariable("entity") String entity) {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getEntityModel(system,entity).getNesteds());
    }

    @RequestMapping(method = RequestMethod.POST, value = "/dst/{system}/entitys/{entity}/get")
    public ResponseEntity<EntityObj> getEntity(@PathVariable("system") String system, @PathVariable("entity") String entity, HttpServletRequest request) {
        Map<String, String[]> params = request.getParameterMap();
        EntityObj entityObj = new EntityObj();
        for (String key : params.keySet()) {
            entityObj.set(key.toUpperCase(),params.get(key)[0]);
        }
        return ResponseEntity.status(HttpStatus.OK).body(liteDataService.get(system,entity,entityObj.getStringValue("link"),entityObj));
    }

    @RequestMapping(method = RequestMethod.POST, value = "/dst/{system}/entitys/{entity}/search{dataset}")
    public ResponseEntity<List<EntityObj>> searchEntity(@PathVariable("system") String system, @PathVariable("entity") String entity, @PathVariable(value = "dataset",required = false) String dataset,@RequestParam(value = "link",required = false) String link,@RequestBody QueryFilter filter) {
        if(StringUtils.isEmpty(dataset))
            dataset="BASE";
        return ResponseEntity.status(HttpStatus.OK).body(liteDataService.search(system,entity,link,filter));
    }

    @RequestMapping(method = RequestMethod.POST, value = "/dst/{system}/entitys/{entity}/save")
    public ResponseEntity<Boolean> saveEntity(@PathVariable("system") String system, @PathVariable("entity") String entity,@RequestParam(value = "link",required = false) String link,@RequestBody EntityObj entityObj) {
        return ResponseEntity.status(HttpStatus.OK).body(liteDataService.save(system,entity,link,entityObj));
    }

    @RequestMapping(method = RequestMethod.POST, value = "/dst/{system}/entitys/{entity}/batch")
    public ResponseEntity<Boolean> saveEntity(@PathVariable("system") String system, @PathVariable("entity") String entity,@RequestBody List<EntityObj> list, @RequestParam(value = "link",required = false) String link) {
        return ResponseEntity.status(HttpStatus.OK).body(liteDataService.saveBatch(system,entity,link,list));
    }

    @RequestMapping(method = RequestMethod.GET, value = "/dst/sysapps")
    public ResponseEntity<List<DstSystem>> getSysApps() {
        return ResponseEntity.status(HttpStatus.OK).body(liteModelService.getSysApp());
    }


}
