/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'modelname',
          prop: 'model_name',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'rulename',
          prop: 'rule_name',
          dataType: 'TEXT',
        },
        {
          name: 'createdate',
          prop: 'createdate',
          dataType: 'DATETIME',
        },
        {
          name: 'modelid',
          prop: 'model_id',
          dataType: 'PICKUP',
        },
        {
          name: 'businesscat',
          prop: 'business_cat',
          dataType: 'TEXT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'rulegroup',
          prop: 'group',
          dataType: 'SMCODELIST',
        },
        {
          name: 'ruleid',
          prop: 'rule_id',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'rule_name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'rule_id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'rule_id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'ruleitem',
          prop: 'rule_id',
        },
      {
        name: 'n_rulename_like',
        prop: 'n_rulename_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_modelname_like',
        prop: 'n_modelname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_systemid_eq',
        prop: 'n_systemid_eq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}