package cn.ibizlab.api.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[DAReportDTO]
 */
@Data
@ApiModel("报表")
public class DAReportDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [REPORTID]
     *
     */
    @JSONField(name = "report_id")
    @JsonProperty("report_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("标识")
    private String reportId;

    /**
     * 属性 [REPORTNAME]
     *
     */
    @JSONField(name = "report_name")
    @JsonProperty("report_name")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("名称")
    private String reportName;

    /**
     * 属性 [DICT]
     *
     */
    @JSONField(name = "dict")
    @JsonProperty("dict")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("过滤项字典")
    private String dict;

    /**
     * 属性 [REPGROUP]
     *
     */
    @JSONField(name = "group")
    @JsonProperty("group")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("分组")
    private String group;

    /**
     * 属性 [VMCFG]
     *
     */
    @JSONField(name = "config")
    @JsonProperty("config")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("展现配置")
    private String config;

    /**
     * 属性 [SYSTEMID]
     *
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("系统标识")
    private String systemId;


    /**
     * 设置 [REPORTNAME]
     */
    public void setReportName(String  reportName){
        this.reportName = reportName ;
        this.modify("reportname",reportName);
    }

    /**
     * 设置 [DICT]
     */
    public void setDict(String  dict){
        this.dict = dict ;
        this.modify("dict",dict);
    }

    /**
     * 设置 [REPGROUP]
     */
    public void setGroup(String  group){
        this.group = group ;
        this.modify("repgroup",group);
    }

    /**
     * 设置 [VMCFG]
     */
    public void setConfig(String  config){
        this.config = config ;
        this.modify("vmcfg",config);
    }

    /**
     * 设置 [SYSTEMID]
     */
    public void setSystemId(String  systemId){
        this.systemId = systemId ;
        this.modify("systemid",systemId);
    }


}


