package cn.ibizlab.api.rest.extensions;

import cn.ibizlab.core.analysis.domain.DAReport;
import cn.ibizlab.core.analysis.service.impl.DAReportServiceImpl;
import cn.ibizlab.core.extensions.domain.FetchMetricDatasParam;
import cn.ibizlab.core.extensions.service.DACoreService;
import cn.ibizlab.util.errors.BadRequestAlertException;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Api(tags = {"接口" })
@RestController("api-dacore")
@RequestMapping("")
public class DACoreResource {

    @Autowired
    private DACoreService daCoreService;

    @Autowired
    private DAReportServiceImpl daReportService;

    /**
     * 通过指标获取相应的规则结果数据
     * @param param
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value="/dst/analyse/reportdata/fetchmetricdatas")
    public ResponseEntity<List<HashMap<String,Object>>> fetchMetricDatas(@Validated @RequestBody FetchMetricDatasParam param){
        List<HashMap<String,Object>> execResults = daCoreService.onFetchMetricDatas(param);
        return ResponseEntity.status(HttpStatus.OK).body(execResults);
    }

    /**
     * 呈报报表获取数据
     * @param param
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value = "/dst/analyse/reportdata/fetchreportdatas")
    public ResponseEntity<Map<String,Object>> fetchReportDatas(@Validated @RequestBody FetchMetricDatasParam param) {
        Map<String, Object> resultMap = daCoreService.onFetchReportDatas(param);
        return ResponseEntity.status(HttpStatus.OK).body(resultMap);
    }

    /**
     * 获取反查数据用到的keyvalue
     * @param param
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value="/dst/analyse/reportdata/fetchkeyvaluefield")
    public ResponseEntity<Map<String, String>> fetchKeyValueField(@Validated @RequestBody FetchMetricDatasParam param) {
        Map<String, String> results = daCoreService.onFetchKeyValueField(param);
        return ResponseEntity.status(HttpStatus.OK).body(results);
    }

    /**
     * 清除绩效数据缓存
     * @param
     * @return
     */
    @RequestMapping(method = RequestMethod.GET, value="dst/analyse/reportdata/resetperformancedata/{resettype}")
    public ResponseEntity<Map<String, Object>> resetPerformanceData(@PathVariable(name="resettype",required = false) String resettype) {
        Map<String, Object> resultMap = new HashMap<>();
        if (StringUtils.isEmpty(resettype)) {
            throw new BadRequestAlertException("请求参数为空", "", "");
        }
        String strType = resettype.toUpperCase();
        switch (strType) {
            case "WORK_ALL":// 消除所有的缓存
                this.daCoreService.resetsnap();
                break;
            case "WORK":// 消除指定指标的缓存
                this.daCoreService.resetsnapSingle();
                break;
            case "JXKH":// 消除绩效报表的缓存
                daCoreService.resetPerformance();
                daCoreService.resetsnap();
                break;
            case "reloadReportData":// 消除绩效报表的缓存
                daCoreService.resetsnapReport();
                break;
            default:
                break;
        }
        return ResponseEntity.status(HttpStatus.OK).body(resultMap);
    }

}
