package cn.ibizlab.api.rest.extensions;


import cn.ibizlab.core.disk.extensions.service.DiskCoreService;
import cn.ibizlab.util.domain.FileItem;
import cn.ibizlab.util.service.FileService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Hashtable;

@Slf4j
@RestController
@RequestMapping("/")
public class DiskCoreResource
{

	@Autowired
	private DiskCoreService diskCoreService;

	private Hashtable<String, String> type = null;
	private String getType(String ext)
	{
		if(type==null)
		{
			type = new Hashtable<String, String>();
			type.put(".pdf", "application/pdf");
			type.put(".jpg", "image/jpg");
			type.put(".jpeg", "image/jpeg");
			type.put(".bmp", "image/bmp");
			type.put(".gif", "image/gif");
			type.put(".tif", "image/tiff");
			type.put(".tiff", "image/tiff");
			type.put(".png", "image/png");
		}

		if(type.containsKey(ext.toLowerCase()))
			return type.get(ext.toLowerCase());
		else
			return "application/octet-stream";

	}

	@PostMapping(value = "{folder}/upload")
	public ResponseEntity<FileItem> upload(@PathVariable("folder") String folder,@RequestParam("file") MultipartFile multipartFile){
		return ResponseEntity.ok().body(diskCoreService.saveFile(folder,multipartFile));
	}

	@PostMapping(value = "{folder}/upload/{id}")
	public ResponseEntity<FileItem> updatefile(@PathVariable("folder") String folder,@PathVariable("id") String id,@RequestParam("file") MultipartFile multipartFile){
		return ResponseEntity.ok().body(diskCoreService.saveFile(folder,id,multipartFile));
	}

	@GetMapping(value = "{folder}/download/{id}")
	@ResponseStatus(HttpStatus.OK)
	public void download(@PathVariable("folder") String folder, @PathVariable("id") String id, HttpServletResponse response){
		File file = diskCoreService.getFile(folder,id);
		response.setHeader("Content-Disposition", "attachment;filename="+getFileName(file.getName()));
		this.sendRespose(response, file);
	}

	@GetMapping(value = "net-disk/download/{folder}/{id}/{name}.{ext}")
	@ResponseStatus(HttpStatus.OK)
	public void download(@PathVariable("folder") String folder, @PathVariable("id") String id,
						  @PathVariable("name") String name, @PathVariable("ext") String ext, HttpServletResponse response){
		File file = diskCoreService.getFile(folder,id);
		response.setHeader("Content-Disposition", "attachment;filename="+getFileName(file.getName()));
		this.sendRespose(response, file);
	}

	@GetMapping(value = "net-disk/file/{folder}/{id}/{name}.{ext}")
	@ResponseStatus(HttpStatus.OK)
	public void open(@PathVariable("folder") String folder, @PathVariable("id") String id,
			@PathVariable("name") String name, @PathVariable("ext") String ext, HttpServletResponse response){
		File file = diskCoreService.getFile(folder,id);
		String type = getType(ext);
		response.setContentType(type);
		if(type.toLowerCase().equals("application/octet-stream"))
			response.setHeader("Content-Disposition", "attachment;filename="+getFileName(file.getName()));
		this.sendRespose(response, file);
	}

	@GetMapping(value = "net-disk/preview/{folder}/{id}/{name}.{ext}")
	@ResponseStatus(HttpStatus.OK)
	public void preview(@PathVariable("folder") String folder, @PathVariable("id") String id,
			@PathVariable("name") String name, @PathVariable("ext") String ext, HttpServletResponse response){
		File file = diskCoreService.getFile(folder,id);
		String type = getType(ext);
		response.setContentType(type);
		if(type.toLowerCase().equals("application/octet-stream"))
			response.setHeader("Content-Disposition", "attachment;filename="+getFileName(file.getName()));
		this.sendRespose(response, file);
	}

	protected void sendRespose(HttpServletResponse response, File file){
		BufferedInputStream bis = null;
		BufferedOutputStream bos = null;
		try {
			bis = new BufferedInputStream(new FileInputStream(file));
			bos = new BufferedOutputStream(response.getOutputStream());
			byte[] buff = new byte[2048];
			int bytesRead;
			while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
				bos.write(buff, 0, bytesRead);
			}
		}
		catch (Exception e) {
			//throw e;
		}
		finally {
			if (bis != null) {
				try {
					bis.close();
				}
				catch (IOException e) {

				}
			}
			if (bos != null) {
				try {
					bos.close();
				}
				catch (IOException e) {

				}
			}
		}
	}

	protected String getFileName(String fileName){
		try {
			return new String(fileName.getBytes("utf-8"),"iso8859-1");//防止中文乱码
		}
		catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return fileName;
	}
}