package cn.ibizlab.util.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import lombok.Data;

@Data
public class DTOBase implements Serializable {

    @JsonIgnore
    @JSONField(serialize = false)
    private Set<String> focusNull;

    @JsonIgnore
    @JSONField(serialize = false)
    public void addFocusNull(String field) {
        getFocusNull().add(field);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public Set<String> getFocusNull() {
        if(focusNull==null)
            focusNull=new HashSet<>();
        return focusNull;
    }

}
