package cn.ibizlab.util.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Data
public class EntityBase implements Serializable {

    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private Set<String> focusNull;


    public void modify(String field,Object val) {
        if(val==null)
            this.getFocusNull().add(field.toLowerCase());
        else
            this.getFocusNull().remove(field.toLowerCase());
    }


    public Set<String> getFocusNull() {
        if(focusNull==null)
            focusNull=new HashSet<>();
        return focusNull;
    }


    public UpdateWrapper getUpdateWrapper(boolean clean) {
        UpdateWrapper wrapper=new UpdateWrapper();
        for(String nullField:getFocusNull()) {
            wrapper.set(nullField,null);
        }
        if(clean)
            focusNull.clear();
        return  wrapper;
    }

    public Serializable getDefaultKey(boolean gen)
    {
        return IdWorker.get32UUID();
    }



}

