import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'

Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/appindexview/:appindexview?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: 'app.views.appindexview.caption',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview', parameterName: 'appindexview' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/dict/app-index-view/app-index-view.vue'),
            children: [
                {
                    path: 'ibzdicts/:ibzdict?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibzdict.views.gridview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ibzdicts', parameterName: 'ibzdict' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/dict/ibzdict-grid-view/ibzdict-grid-view.vue'),
                },
                {
                    path: 'ibzdicts/:ibzdict?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibzdict.views.editview.caption',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'ibzdicts', parameterName: 'ibzdict' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/dict/ibzdict-edit-view/ibzdict-edit-view.vue'),
                },
            ...indexRoutes,
            ],
        },
    {
        path: '/ibzdicts/:ibzdict?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibzdict.views.gridview.caption',
            parameters: [
                { pathName: 'ibzdicts', parameterName: 'ibzdict' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/dict/ibzdict-grid-view/ibzdict-grid-view.vue'),
    },
    {
        path: '/ibzdicts/:ibzdict?/editview/:editview?',
        meta: {
            caption: 'entities.ibzdict.views.editview.caption',
            parameters: [
                { pathName: 'ibzdicts', parameterName: 'ibzdict' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/dict/ibzdict-edit-view/ibzdict-edit-view.vue'),
    },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview'
        },
    ],
});

export default router;
